﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="KalendarControl.ascx.cs"
    Inherits="KSPortal.Controls.KalendarControl" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="scheduler" TagName="AdvancedForm" Src="KalendarAdvancedForm.ascx" %>
<%@ Register TagPrefix="ucsum" TagName="Sumar" Src="~/Dochazka/UC_SumVacations.ascx" %>

<style type="text/css">
    div.rts-RadTabStrip1 .rtsUL {
        float: left !important;
    }

    div.rpTempPadd > ul {
        width: 100%;
    }

        div.rpTempPadd > ul > li:first-child + li + li > div > div {
            padding: 0px;
        }

        div.rpTempPadd > ul > li:first-child > div > div > div, div.rpTempPadd > ul > li:first-child + li > div > div > div {
            line-height: 1;
        }

            div.rpTempPadd > ul > li:first-child > div > div > div > div > label > label, div.rpTempPadd > ul > li:first-child + li > div > div > div > div > label > label {
                /*vertical-align: text-top;*/
            }
    /*div.rpTempPadd > ul > li:first-child + li + li > div > div > div > div:first-child + div > table > tbody > tr > td 
    {
        padding-top: 1px !important;
        padding-bottom: 1px !important;
    }*/

    div.ksKalTempl {
        margin: 5px 0px 5px 10px;
    }

        div.ksKalTempl.ksPoz {
            border-bottom: solid 1px var(--kscolor1);
        }

    div.kalItem {
        margin: 2px 0;
    }

        div.kalItem > label {
            vertical-align: text-top;
            /*border-radius: 5px;*/
            padding: 0px 1px 1px 1px;
            font-weight: bold;
        }

    div.GridNoBorder {
        border: 0 none;
        word-wrap: initial !important;
    }

    /*div.GridNoBorder div.rgDataDiv {
            height: calc(100% - 179px) !important;
        }*/

    .trg-kalendar .rgCaption {
        display: none;
    }

    .trg-kalendar .daycss {
        padding: 1px !important;
        margin: 0px !important;
        font-size: xx-small !important;
        font-weight: bold !important;
        width: 23px;
        line-height: 1;
        text-align: center;
    }

    .trg-kalendar .dayHeader {
        width: 27px;
        text-align: center !important;
        padding: 0px !important;
    }

    .smena {
        display: block;
        text-align: center;
        border: 1px solid;
    }

    .smenae {
        height: 10px;
    }

    .smena:hover {
        background-color: #BDBDBD !important;
    }

    .hedSvatek {
        font-weight: bold !important;
        color: Red !important;
    }

    .sudItemSvatek {
        background-color: #F5F5F5 !important;
    }

    .lichItemSvatek {
        background-color: #E0E0E0 !important;
    }

    .Svatek {
        background: #FFC8C8 !important;
    }

        .Svatek.rsAptCreate {
            background: #FFC8C8 !important;
        }

    .pdfExport {
    }

    .k-pdf-export .pdfExport {
        font-family: Arial, Arial Black !important;
    }

    .k-pdf-export .rgPager, .k-pdf-export .rgFilterRow, .k-pdf-export .rgCommandRow {
        display: none;
    }

    .ksTodayPart {
        background-color: #e3f3fb !important; /*ještě světlejší metro modrá*/
    }


    .RadScheduler .ks-app-style .rsAptContent,
    .RadScheduler .ks-app-style .rsAptMid .rsAptIn,
    .RadScheduler .ks-app-style .rsAptMid,
    .RadScheduler .ks-app-style .rsAptOut {
        border-radius: 5px;
    }

    .RadScheduler .ks-app-style .rsAptIn {
        margin-left: 7px;
        margin-right: 7px;
        margin-top: 1px;
        margin-bottom: 1px;
        /*height: 19px;*/
    }

    .RadScheduler .ks-app-style .rsAptContent {
        border-width: 2px;
    }

    .RadScheduler .ks-app-style .rsAptOut {
    }

    .RadScheduler .ks-app-style .rsAptContent {
        /*font style*/
        /*color: White;*/
        font-size: 12px;
        font-weight: bold;
        line-height: 1.3;
    }

    .RadScheduler .ks-app-style-l .rsAptContent {
        /*font style*/
        /*color: black;*/
    }

    /*HID:48604*/
    .ksRadSheduler .rsHeader {
        z-index: auto !important;
    }

    .ksRadSheduler .rsAptContent {
        background-image: none !important;
    }

    .ksRadSheduler .rsArrowRight {
        right: 0px !important;
    }

    .ksRadSheduler .rsArrowLeft {
        left: 0px !important;
    }

    .RadScheduler_Metro.ksRadSheduler div.rsHeader li.rsSelected > .rsButton {
        color: var(--kscolor1text) !important;
        background-color: var(--kscolor1) !important;
    }

    .RadScheduler_Metro.ksRadSheduler div.rsHeader .rsToolbar.rsViews .rsButton {
        border: 1px transparent solid;
        color: var(--kscolor1);
        background-color: var(--kscolor1text);
        cursor: pointer;
    }

        .RadScheduler_Metro.ksRadSheduler div.rsHeader .rsToolbar.rsViews .rsButton.rsHovered {
            border-color: var(--kscolor1);
        }

    .RadScheduler_Metro.ksRadSheduler div.rsHeader .rsCurrent.rsDatePickerActivator {
        color: var(--kszahlavitext);
    }

    .RadScheduler_Metro.ksRadSheduler .rsSelectedSlot {
        color: var(--kscolor1text);
        background-color: var(--kscolor1);
    }

    .ksRscmItem img {
        height: 18px;
        margin-top: -10px !important;
    }
</style>
<telerik:RadScriptBlock ID="RadCodeBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
        //<![CDATA[
        //var $ = $telerik.$;
        var Kalendare = new Array();
        var Pozadavky = new Array();
        var Stavy = new Array();
        var SchedulerNavigationCompleteAlreadyOccurred = false;
        var timePerMinute = 60000;
        var timePerHour = timePerMinute * 60;
        var timePerDay = timePerHour * 24;
        var _gridLastBoundedDate;
        var _bindScheduler = false;
        //var _primi = false;
        var isPageLoaded = false;
        //var rowSelectedTimeout;

        var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
        KSMaster.onPageLoad = function () {
            oldPageLoad1.apply();

            setSavedKalendarsStateFromHF();

            isPageLoaded = true;
            rebindData(true);
            setShedulerStyles($find('<%=RadScheduler1.ClientID %>'));

            KSMaster.jenPrimiPodrizeniChangedAdd(function () {
                var PrimiPodrizeniButton1 = $find('<%= TRG_kalendar.GetGridCommandItemControl.PrimiPodrizeniButton.ClientID%>');
                var _ch = KSMaster.HF_Globals_JenPrimePodrizene.value == "true";
                if (PrimiPodrizeniButton1.get_checked() != _ch)
                    PrimiPodrizeniButton1.set_checked(_ch);
            });
            if (KSMaster.PozadavekWindow)
                KSMaster.PozadavekWindow.OnCloseAdd(function () {
                    rebindScheduler();
                });

            KSMaster.resizeContentAdd(function () {
                setTimeout(function () {
                    onResizeContent();
                }, 1000);
            });
        };
        KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;

        var oldSeznamOsCisloPomChanged = !oldSeznamOsCisloPomChanged ? KSMaster.onSeznamOsCisloPomChanged : oldSeznamOsCisloPomChanged;
        KSMaster.onSeznamOsCisloPomChanged = function (sender, args) {
            oldSeznamOsCisloPomChanged.apply(sender, args);
            rebindScheduler(true);
        };
        KSMaster.onSeznamOsCisloPomChanged.prototype = oldSeznamOsCisloPomChanged.prototype;

        function onResizeContent() {
            if (KSMaster.SumarDovoleneWindow && KSMaster.SumarDovoleneWindow.Window) {
                var tab_strip = $find('<%= RadTabStrip1.ClientID %>');
                if (tab_strip) {
                    var pos = tab_strip.get_element().getBoundingClientRect();
                    var top = pos.top + 3;
                    var left = pos.left + 180;
                    KSMaster.SumarDovoleneWindow.Window.moveTo(left + "px", top + "px");
                }
            }
        }

        function repaintCalendar() {
            var RadSplitter1 = $find('<%=RadSplitter1.ClientID%>');
            var RadSplitter2 = $find('<%=RadSplitter2.ClientID%>');
            var RadScheduler1 = $find('<%=RadScheduler1.ClientID%>');
            var TRG_kalendar = $find('<%=TRG_kalendar.ClientID%>');

            if (RadSplitter1)
                setTimeout(function () {
                    RadSplitter1.repaint();
                });
            if (RadSplitter2)
                setTimeout(function () {
                    RadSplitter2.repaint();
                });
            if (RadScheduler1)
                setTimeout(function () {
                    RadScheduler1.repaint();
                });
            if (TRG_kalendar)
                setTimeout(function () {
                    resizeToFit(TRG_kalendar);
                });
            repaintGrid();
        }

        function repaintGrid() {
            var TRG_kalendar = $find('<%=TRG_kalendar.ClientID%>');
            if (TRG_kalendar)
                setTimeout(function () {
                    resizeToFit(TRG_kalendar, false);
                }, 10);
        }

        function RadPane2_Resized(sender, args) {
            repaintGrid();
        }

        function addSelectedKalendareToArray() {
            $("#<%=RPB_typy_kal.ClientID %> li:first-child").find(':checkbox:checked').each(function () {
                Kalendare.push($telerik.$(this).attr('value'));
            });
        }
        function addSelectedPozadavkyToArray() {
            $("#<%=RPB_typy_kal.ClientID %> li:odd").find(':checkbox:checked').each(function () {
                var val = $telerik.$(this).attr('value');
                if (val == "n" || val == "r" || val == "s" || val == "o") {
                    Stavy.push($telerik.$(this).attr('value'));
                }
                else {
                    Pozadavky.push(val);
                }
            });
        }
        function setSavedKalendarsStateFromHF() {
            var kalendare = $get('<%=HF_kalendareCheckedState.ClientID%>')?.value?.split(',');
            var pozadavky = $get('<%=HF_pozadavkyCheckedState.ClientID%>')?.value?.split(',');
            var stavy = $get('<%= HF_stavyPoz.ClientID%>')?.value?.split(',');

            var k = $("#<%=RPB_typy_kal.ClientID %> li:first-child");
            kalendare?.forEach(function (item) {
                if (item)
                    k.find('[value=' + item + ']').prop('checked', true);
            });

            var p = $("#<%=RPB_typy_kal.ClientID %> li:odd");
            pozadavky?.forEach(function (item) {
                if (item)
                    p.find('[value=' + item + ']').prop('checked', true);
            });
            stavy?.forEach(function (item) {
                if (item)
                    p.find('[value=' + item + ']').prop('checked', true);
            });
        }
        function GetGridServerElement(serverID, tagName, getMetot) {
            if (!tagName)
                tagName = "*"; //* means all elements 

            var grid = document.getElementById("<%=TRG_kalendar.ClientID %>");
            var elements = grid.getElementsByTagName(tagName);
            for (var i = 0; i < elements.length; i++) {
                var element = elements[i];
                if (element.id.indexOf(serverID) >= 0) {
                    var ret = null;
                    if (!getMetot || getMetot == "find") {

                        ret = $find(element.id);
                    }
                    else {
                        ret = $get(element.id);
                    }
                    if (ret) {
                        return ret;
                    }
                }
            }
            return null;
        }

        function RS1_ResourcesPopulating(sender, args) {

        }

        function RadScheduler1_AppointmentsPopulating(sender, eventArgs) {
            var RTS = $find('<%=RadTabStrip1.ClientID %>');
            if (RTS == null || !isPageLoaded) {
                eventArgs.set_cancel(true);
                return;
            }
            if (RTS._selectedIndex != 0 || !_bindScheduler || !sender.get_visible())
                eventArgs.set_cancel(true);
            addSelectedKalendareToArray();
            eventArgs.get_schedulerInfo().Kalendare = Kalendare;
            Kalendare = new Array();

            addSelectedPozadavkyToArray();
            eventArgs.get_schedulerInfo().Pozadavky = Pozadavky;
            Pozadavky = new Array();

            eventArgs.get_schedulerInfo().Stavy = Stavy;
            Stavy = new Array();

            if (!eventArgs.get_cancel()) {
                $find("<%= RadAjaxLoadingPanel1.ClientID %>").show("<%= RadMultiPage1.ClientID %>");
            }
        }

        function RadScheduler1_AppointmentsPopulated(sender, args) {
            var apps = sender.get_appointments();

            if (sender.get_activeModel()._contentElement?.classList.contains("rsYearMonthsWrap")) {
                resetYearViewSlotsCss(apps);
            }

            for (var i = 0; i < apps.get_count(); i++) {
                var app = apps.getAppointment(i);
                if (app.get_attributes().getAttribute("AllowDelete") == 0) {
                    app.set_allowDelete(false);
                }

                if (app.get_attributes().getAttribute("AllowEdit") == 0) {
                    app.set_allowEdit(false);
                }
            }
            $find("<%= RadAjaxLoadingPanel1.ClientID %>").hide("<%= RadMultiPage1.ClientID %>");
        }

        function RS_DataBound(sender, args) {
            rebindSumar();
        }

        function resetYearViewSlotsCss(apps) {
            var slots = $telerik.$(".ksRadSheduler .rsYearView .rsYearMonthWrap td:has(a.rsDateHeader)");
            slots.css({
                "background-image": "unset"
            });

            $telerik.$(".ksRadSheduler .rsYearView .rsYearMonthWrap td.rsOtherMonth").css({
                "background-image": "unset"
            });

            for (slotIndex in slots) {
                var slot = slots[slotIndex];
                var slotDate = new Date($telerik.$(slot.childNodes).attr('href')?.substring(1));
                slotDate = slotDate.addMinutes(slotDate.getTimezoneOffset());
                var f = apps.getAppointmentsInRange(slotDate, slotDate.addDays(1));
                if (f?.get_count() > 0) {
                    var gradient = 'linear-gradient(to bottom right';
                    for (ai in f._array) {
                        gradient += ', ' + f._array[ai].get_backColor();
                    }
                    if (f?.get_count() == 1) {
                        gradient += ', ' + f._array[0].get_backColor();
                    }
                    gradient += ')';
                    $telerik.$(slot).css({
                        "background-image": gradient
                    });
                }
            }

        }

        function RadScheduler1_ContextMenuItemClicking(sender, args) {

        }

        function RadScheduler1_RequestSuccess(sender, args) {
            var result = args.get_result();
            if (result && result.length && result.length == 1 && result[0].ID == "error") {
                var err = result[0].Description;
                result.shift();
                KSMaster.showError(err, 'Web Service Error', 0, 0);
            }
            //result.forEach(function (app, i, arr) {
            //    setAppointmentStyle(app);
            //});
            onShedulerRequestEnd(sender, args);
        }

        function RadScheduler1_RequestFailed(sender, args) {
            onShedulerRequestEnd(sender, args);
        }

        function rebindData(cond) {
            rebindScheduler(cond);
            rebindGrid(cond);
        }
<%--        function rebindScheduler(cond) {
            var scheduler1 = $find('<%=RadScheduler1.ClientID %>');
            if (scheduler1)
                scheduler1.rebind();
        }--%>

        let isRebinding = false;
        let pendingRebind = false; // Určuje, zda máme čekající požadavek na rebind

        function rebindScheduler() {
            var str = $find("<%= RadTabStrip1.ClientID %>");
            if (str) {
                if (str.get_selectedIndex() != 0)
                    return;
                if (isRebinding) {
                    // Pokud je rebind již v běhu, nastavíme pendingRebind na true, pokud ještě nebyl nastaven
                    if (!pendingRebind) {
                        pendingRebind = true; // Požadavek na rebind je čekající
                    }
                    return;
                }

                // Zahájení rebindu
                isRebinding = true;
                pendingRebind = false; // Resetování požadavku na rebind

                const scheduler = $find("<%= RadScheduler1.ClientID %>");
                if (scheduler)
                    scheduler.rebind();
            }
        }

        function onShedulerRequestEnd(sender, args) {
            // Tato funkce je volána po dokončení každého AJAX požadavku
            isRebinding = false;
            if (pendingRebind) {
                // Pokud je čekající požadavek, provede se rebind
                rebindScheduler();
            }
        }

        function rebindGrid(cond) {
            var str = $find("<%= RadTabStrip1.ClientID %>");
            if (str) {
                if (str.get_selectedIndex() != 1)
                    return;
                var TRG_kalendar = $find("<%=TRG_kalendar.ClientID %>");
                var calendar = $find("<%=RC_obdobi.ClientID %>");
                if (TRG_kalendar && calendar) {
                    var caldatetrip = calendar.get_focusedDate();
                    if (cond || !(_gridLastBoundedDate && caldatetrip[0] == _gridLastBoundedDate[0] && caldatetrip[1] == _gridLastBoundedDate[1])) {
                        var tablewiew = TRG_kalendar.get_masterTableView();
                        if (tablewiew)
                            TRG_kalendar.get_masterTableView().rebind();
                    }
                }
            }
        }

        // Advanced Form ----------------------
        var schedulerTemplates = {};

        function schedulerFormCreated(scheduler, eventArgs) {
            // Create a client-side object only for the advanced templates
            var mode = eventArgs.get_mode();
            if (mode == Telerik.Web.UI.SchedulerFormMode.AdvancedInsert ||
                mode == Telerik.Web.UI.SchedulerFormMode.AdvancedEdit) {
                // Initialize the client-side object for the advanced form
                var formElement = eventArgs.get_formElement();
                var templateKey = scheduler.get_id() + "_" + mode;
                var advancedTemplate = schedulerTemplates[templateKey];
                if (!advancedTemplate) {
                    // Initialize the template for this RadScheduler instance
                    // and cache it in the schedulerTemplates dictionary
                    var schedulerElement = scheduler.get_element();
                    var isModal = scheduler.get_advancedFormSettings().modal;
                    advancedTemplate = new window.SchedulerAdvancedTemplate(schedulerElement, formElement, isModal);
                    advancedTemplate.initialize();

                    schedulerTemplates[templateKey] = advancedTemplate;

                    // Remove the template object from the dictionary on dispose.
                    scheduler.add_disposing(function () {
                        schedulerTemplates[templateKey] = null;
                    });
                }

                // Are we using Web Service data binding?
                if (!scheduler.get_webServiceSettings().get_isEmpty()) {
                    // Populate the form with the appointment data
                    var apt = eventArgs.get_appointment();
                    var isInsert = mode == Telerik.Web.UI.SchedulerFormMode.AdvancedInsert;
                    advancedTemplate.populate(apt, isInsert);
                }
            }
        }

        function RadScheduler1_AppointmentCreated(sender, args) {
            var apt = args.get_appointment();
            var elements = apt.get_elements();
            for (let i = 0; i < elements.length; i++) {
                var elemAptContent = elements[i].getElementsByClassName("rsAptContent")[0];
                if (elemAptContent) {
                    var backColor = args.get_appointment().get_backColor();
                    if (backColor) {
                        var inverted = (new RGBHexColour(backColor).getContrastColorInHue(7) ?? new RGBHexColour(backColor).getContrastColorInHue(4.5))?.getCSSHexadecimalRGB();
                        if (inverted)
                            elemAptContent.style.color = inverted;
                    }
                }
            }
        }

        function OnClientAppointmentDataBound(sender, eventArgs) {
            var app = eventArgs.get_appointment();
            setAppointmentStyle(app);
        }
        // Advanced Form ---------------------- end

        function setAppointmentStyle(app) {
            app.set_cssClass("ks-app-style");
            var backColor = app.get_attributes().getAttribute("AppointmentColor");
            if (backColor) {
                app.set_backColor(backColor);
                app.set_borderColor(backColor);
                //var col = new RGBHexColour(backColor);
                //if (col && col.getHSL().l > 54) {
                //    app.set_cssClass("ks-app-style ks-app-style-l");
                //}
            }
            var borderColor = app.get_attributes().getAttribute("borderColor");
            if (borderColor) {
                app.set_borderColor(borderColor);
            }
            return app;
        }

        function RadScheduler1_ResourcesPopulated(sender, args) {

        }
        function TRG_kalendar_OnGridCreated(sender, args) {
            sender.get_element().parentNode.style.height = "100%";

            var masterTable = sender.get_masterTableView();
            masterTable.hideFilterItem();

            var column = masterTable.getColumnByUniqueName("OsCislo");
            if (KSMaster.OsCisloIsPrivate) {
                masterTable.hideColumn(column.get_element().cellIndex);
            }
            else {
                masterTable.showColumn(column.get_element().cellIndex);
            }
        }

        function TRG_kalendar_OnDataBinding(sender, args) {
            var RTS = $find('<%=RadTabStrip1.ClientID %>');
            var calendar = $find("<%=RC_obdobi.ClientID %>");
            var caldatetrip;
            if (calendar) {
                caldatetrip = calendar.get_focusedDate();
            }
            else {
                args.set_cancel(true);
                return;
            }

            var parentWindow = $find('<%=this.ParentWindow==null ? "" : this.ParentWindow.ClientID %>');
            if (parentWindow && !parentWindow.isVisible()) {
                args.set_cancel(true);
                return;
            }

            if (!RTS) {
                args.set_cancel(true);
                return;
            }
            if (RTS._selectedIndex != 1) {
                args.set_cancel(true);
                return;
            }
            else {
                if (isPageLoaded && sender.get_visible()) {
                    $find("<%= RadAjaxLoadingPanel1.ClientID %>").show("<%= RadMultiPage1.ClientID %>");
                }
                else {
                    args.set_cancel(true);
                    return;
                }
            }

            KSMaster.GridFilterCaseInsensitive(sender, args);

            var m_args = args.get_methodArguments();
            m_args.filterExpression += m_args.filterExpression == "" ? "" : " AND ";
            m_args.filterExpression += 'mesic = "' + caldatetrip + '"';
            addSelectedKalendareToArray();
            m_args.filterExpression += ' AND kalendare = [' + (Kalendare.length == 0 ? '' : ('"' + Kalendare.join('","') + '"')) + ']';
            addSelectedPozadavkyToArray();
            m_args.filterExpression += ' AND pozadavky = [' + (Pozadavky.length == 0 ? '' : ('"' + Pozadavky.join('","') + '"')) + ']';
            m_args.filterExpression += ' AND stavy = [' + (Stavy.length == 0 ? '' : ('"' + Stavy.join('","') + '"')) + ']';
            m_args.filterExpression += ' AND primi = ' + KSMaster.HF_Globals_JenPrimePodrizene.value;

            var HF_Filter = GetGridServerElement("HF_Filter", "input", "get");
            var HF_Sort = GetGridServerElement("HF_Sort", "input", "get");
            if (HF_Filter && HF_Sort) {
                HF_Sort.value = sender.get_masterTableView().get_sortExpressions().toString();
                HF_Filter.value = m_args.filterExpression;
            }
            //zapíšu filtry do session na serveru, protože ukládání do HF selhává
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Zamestnanec/ZamKalendar.aspx/SaveFiltersForExport",
                data: "{sort: '" + sender.get_masterTableView().get_sortExpressions().toString() + "', filter: '" + m_args.filterExpression + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                error: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                success: function (msg) {

                }
            });

            Kalendare = new Array();
            Pozadavky = new Array();
            Stavy = new Array();

            args.set_methodArguments(m_args);

            //před bindováním je nutno zobrazit skryté nefrozen sloupce 
            var masterTableView = sender.get_masterTableView();
            var columns = masterTableView.get_columns();
            var nfzcollumns = sender._scrolling._notFrozenColumns;
            if (nfzcollumns && nfzcollumns.length && nfzcollumns.length > 0) {
                for (var i = 0; i < nfzcollumns.length; i++) {
                    if (!columns[nfzcollumns[i].Index].get_visible()) {
                        masterTableView.showColumn(nfzcollumns[i].Index);
                    }
                }
            }
        }

        function TRG_kalendar_OnRowDataBound(sender, args) {
            var item = args.get_item();
            var data = args.get_dataItem();
            var calendar = $find("<%=RC_obdobi.ClientID %>");
            var caldatetrip = calendar.get_focusedDate();
            var obdobiFirst = getObdobiFirst(new Date(caldatetrip[0], caldatetrip[1] - 1, caldatetrip[2]));
            var obdobiLast = getObdobiLast(obdobiFirst);
            //var HF_rowData = item.findElement("HF_RowData_" + data.OsCislo.toString());
            //HF_rowData.value = JSON.stringify(data.RowData);

            for (var i in data.RowData) {
                var apt = VytvorApt(data.RowData[i]);
                var aptStart = apt.get_start();
                var aptEnd = apt.get_end();
                aptEnd = new Date(aptEnd.getTime() - 1);
                aptStart = aptStart < obdobiFirst ? obdobiFirst : aptStart;
                aptEnd = aptEnd > obdobiLast ? obdobiLast : aptEnd;

                var hsv = new RGBHexColour(apt.get_backColor()).getHSV();
                var border = new HSVColour(hsv.h, hsv.s, (hsv.v * 0.8)).getCSSHexadecimalRGB();

                for (var d = aptStart; d <= aptEnd; d = new Date(d.getTime() + timePerDay)) {
                    var Holder = item.findElement("holder_" + data.OsCislo.toString() + "_d" + d.getDate().toString());
                    if (Holder) {
                        Holder.innerHTML = Holder.innerHTML +
                            '<span title="' + apt.get_toolTip() + '" ' +
                            'style="background-color: ' + apt.get_backColor() + '; ' +
                            'border-color: ' + border + ';" ' +
                            'class="smena smenae"' +
                            'ondblclick="OnDblClickSpan(this, \'' + apt.get_id() + '\', ' + item.get_itemIndexHierarchical() + ', [' + d.getFullYear() + ',' + d.getMonth() + ',' + d.getDate() + '])"' +
                            '></span>';
                    }
                }
            }
            for (var d = obdobiFirst; d <= obdobiLast; d = new Date(d.getTime() + timePerDay)) {
                var cell = item.get_cell("d" + d.getDate().toString()).className = "daycss";
            }
        }
        var svatky;
        function TRG_kalendar_OnDataBound(sender, args) {
            var items = sender.get_masterTableView().get_dataItems();
            if (items[0]) {
                svatky = items[0].get_dataItem().Svatky;
            }
            var masterTableView = sender.get_masterTableView();
            var calendar = $find("<%=RC_obdobi.ClientID %>");
            var caldatetrip = calendar.get_focusedDate();
            var obdobiFirst = getObdobiFirst(new Date(caldatetrip[0], caldatetrip[1] - 1, caldatetrip[2]));
            var obdobiLast = getObdobiLast(obdobiFirst);
            for (var i = 1; i <= 31; i += 1) {
                var column = masterTableView.getColumnByUniqueName("d" + i.toString());
                if (i > obdobiLast.getDate()) {
                    if (column.get_visible()) {
                        masterTableView.hideColumn(column.get_element().cellIndex);
                    }
                }
                else {
                    if (!column.get_visible()) {
                        masterTableView.showColumn(column.get_element().cellIndex);
                    }

                    var curDate = new Date(caldatetrip[0], caldatetrip[1] - 1, i);
                    if (column.get_element().childNodes[3]) {
                        var label = $get(column.get_element().childNodes[3].id);
                        label.innerText = calendar._formatInfoArray[1][curDate.getDay()];
                    }
                    var je_svatek = false;
                    if (svatky) {
                        svatky.forEach(function (element, index, array) {
                            var datum = new Date(element[0], element[1] - 1, element[2]);
                            if (datum.getDate() == curDate.getDate() &&
                                datum.getMonth() == curDate.getMonth() &&
                                datum.getFullYear() == curDate.getFullYear())
                                je_svatek = true;
                        });
                    }
                    if (curDate.getDay() == 0 || curDate.getDay() == 6 || je_svatek) {
                        addClass(column.get_element(), "hedSvatek");
                        addClass(column.get_element(), "sudItemSvatek");
                        var element = column.get_element();
                        for (var y in masterTableView.get_dataItems()) {
                            var cell = masterTableView.get_dataItems()[y].get_cell("d" + i.toString());
                            if (y % 2 == 0) {
                                addClass(cell, "sudItemSvatek");
                            }
                            else {
                                addClass(cell, "lichItemSvatek");
                            }
                        }
                    }
                    else {
                        column.get_element().classList.remove("hedSvatek");
                        column.get_element().classList.remove("sudItemSvatek");
                        for (var y in masterTableView.get_dataItems()) {
                            var cell = masterTableView.get_dataItems()[y].get_cell("d" + i.toString());
                            cell.classList.remove("sudItemSvatek");
                            cell.classList.remove("lichItemSvatek");
                        }
                    }
                }
            }
            _gridLastBoundedDate = caldatetrip;
            resizeToFit(sender);
            $find("<%= RadAjaxLoadingPanel1.ClientID %>").hide("<%= RadMultiPage1.ClientID %>");

            if (isExporting) {
                var cem = $find("<%=RCEM_manager.ClientID%>");
                var grid = $find("<%=TRG_kalendar.ClientID %>")
                var view = grid.get_masterTableView();
                var items = view.get_dataItems();
                var gridelement = grid.get_element();
                var headerelement = gridelement.getElementsByClassName("rgHeaderDiv")[0].getElementsByTagName("thead")[0].cloneNode(true);
                var html_header = headerelement.getElementsByTagName("tr")[0].innerHTML;
                html_header = html_header.replace("<th ", "<td ");
                html_header = html_header.replace("</th>", "</td>");

                var sirka = 0;
                var vyska = 0;

                pridaneIndexy = [];

                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    var bounds = $telerik.getBounds(item.get_element());
                    var sirka = bounds.width;
                    var vyska = vyska + bounds.height;
                    if ((297 / 210 < vyska / sirka) || (i == 0)) {
                        if (i != 0) {
                            var sirka = 0;
                            var vyska = 0;
                            item.addCssClass("pageBreak");
                        }
                        i++;
                    }
                    else {
                        item.removeCssClass("pageBreak");
                    }
                }

                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    item._itemIndex = i;
                    item._itemIndexHierarchical = i;
                }
                var printelement = view.get_element();
                cem.exportPDF(printelement);

                isExporting = false;
            }
        }

        var pridaneIndexy = new Array();

        function RCEM_manager_PdfExported(sender, args) {
            var grid = $find("<%=TRG_kalendar.ClientID %>")
            var view = grid.get_masterTableView();

            view.set_pageSize(pagesize);
        }

        function resizeToFit(grid, justRepaint) {
            var columns = grid.get_masterTableView().get_columns();
            var totalWidth = 50;
            for (var i = 0; i < columns.length; i++) {
                var name = columns[i].get_uniqueName();
                if (!justRepaint) {
                    try {
                        columns[i].resizeToFit(true);
                    } catch (e) { };
                    if (grid.get_masterTableView().get_isFilterItemVisible()) {
                        var el = columns[i].get_element();
                        var min = 25;
                        min = name == "OsCislo" ? 95 : min;
                        min = name == "Jmeno" ? 100 : min;
                        min = name == "kmen_str_cislo" ? 95 : min;
                        min = name == "kmen_str" ? 100 : min;
                        min = name == "cis_pracmist" ? 95 : min;
                        min = name == "naz_pracmist" ? 100 : min;
                        if (columns[i].get_visible() == true) {
                            if (el.offsetWidth < min) {
                                grid.get_masterTableView().resizeColumn(i, min);
                            }
                        }
                        else {
                            grid.get_masterTableView().resizeColumn(i, 0);
                        }
                    }
                    //nastavení šířky sloupce pro den
                    if (name[0] == "d") {
                        grid.get_masterTableView().resizeColumn(i, 27);
                    }
                }
                if (columns[i].get_visible())
                    totalWidth += columns[i].get_element().clientWidth;
            }

            grid.repaint();

            //přepočet šířky rolovátka podle nové šířky sloupců
            var FrozenScroll = $get(grid.get_id() + '_FrozenScroll');
            FrozenScroll.style.width = totalWidth + 'px';

            var Frozen = $get(grid.get_id() + '_Frozen');
            Frozen.style.height = '17px';

            //$(document).ready(function fn() { $(".riTextBox").css("width", "80%"); });
        }
        function addClass(element, trida) {
            if (!element.classList.contains(trida))
                element.classList.add(trida);
        }
        function VytvorApt(data) {
            var apt = new Telerik.Web.UI.SchedulerAppointment();
            apt.set_start(new Date(data.Start[0], data.Start[1] - 1, data.Start[2], data.Start[3], data.Start[4], data.Start[5]));
            apt.set_end(new Date(data.End[0], data.End[1] - 1, data.End[2], data.End[3], data.End[4], data.End[5]));
            apt.set_subject(data.Subject);
            apt.set_description(data.Description);
            apt.get_attributes().setAttribute("AppointmentColor", data.BColor);
            apt.set_backColor(data.BColor);
            apt.set_allowDelete(false);
            apt.set_allowEdit(false);
            apt.set_toolTip(apt.get_description());
            apt._id = data.ID;
            for (var i in data.Resources) {
                var datares = data.Resources[i];
                var res = new Telerik.Web.UI.SchedulerResource();
                res.set_type(datares.Type);
                res.set_key(datares.Key);
                apt.get_resources().add(res);
            }

            return apt;
        }

        function RadTabStrip1_TabSelected(sender, args) {
            if (args.get_tab().get_index() == 0) {
                rebindScheduler();
            }
            if (args.get_tab().get_index() == 1) {
                if (isPageLoaded)
                    rebindGrid();
            }
        }

        var SchedulerNavigationCompleteAlreadyOccurred = false;
        function RadScheduler1_NavigationComplete(sender, args) {
            SchedulerNavigationCompleteAlreadyOccurred = true;
            var selectedDate = sender.get_selectedDate();
            var calendar = $find("<%=RC_obdobi.ClientID %>");
            _setHF(selectedDate);
            calendar.navigateToDate([selectedDate.format("yyyy"), selectedDate.format("MM"), selectedDate.format("dd")]);

            setShedulerStyles(sender);
        }
        function setShedulerStyles(sender) {
            if (sender) {
                var scheduler = sender;
                var schedulerElement = scheduler.get_element();
                $telerik.$(".rsTopWrap .rsContentTable td", schedulerElement).each(function () {
                    var slot = scheduler.get_activeModel().getTimeSlotFromDomElement(this);
                    var today = new Date();
                    if (je_svatek(slot.get_startTime())) {
                        slot.get_domElement().classList.add("ksSvatek");
                        slot.get_domElement().classList.remove("ksSobota");
                        slot.get_domElement().classList.remove("ksNedele");
                    }
                    else {
                        slot.get_domElement().classList.remove("ksSvatek");
                        if (slot.get_startTime().getDay() == 6) {
                            slot.get_domElement().classList.add("ksSobota");
                        }
                        else {
                            slot.get_domElement().classList.remove("ksSobota");
                        }
                        if (slot.get_startTime().getDay() == 0) {
                            slot.get_domElement().classList.add("ksNedele");
                        }
                        else {
                            slot.get_domElement().classList.remove("ksNedele");
                        }
                    }
                    if (slot.get_startTime().getFullYear() == today.getFullYear() &&
                        slot.get_startTime().getMonth() == today.getMonth() &&
                        slot.get_startTime().getDate() == today.getDate()) {
                        if (slot.get_isAllDay())
                            slot.get_domElement().classList.add("ksToday");
                        else
                            slot.get_domElement().classList.add("ksTodayPart");
                    }
                    else {
                        if (slot.get_isAllDay())
                            slot.get_domElement().classList.remove("ksToday");
                        else
                            slot.get_domElement().classList.remove("ksTodayPart");
                    }
                });
            }
        }
        function je_svatek(datum) {
            var svat = get_svatky();
            var ret = false;
            var BreakException = {};
            if (svat)
                try {
                    svat.forEach(function (item, index) {
                        if (datum.getFullYear() == item[0] && (datum.getMonth() + 1) == item[1] && datum.getDate() == item[2]) {
                            ret = true;
                            throw BreakException;
                        }
                    });
                }
                catch (e) {
                    if (e !== BreakException) throw e;
                }
            return ret;
        }
        function get_svatky() {
            var svStr = $get("<%=HF_svatky.ClientID %>").value;
            if (svStr)
                try {
                    return $telerik.$.parseJSON($get("<%=HF_svatky.ClientID %>").value);
                }
                catch (err) {
                    return null;
                }
            else
                return null;
        }
        function RC_obdobi_OnCalendarViewChanged(sender, args) {
            var dateTriplet = sender.get_focusedDate();

            if (!SchedulerNavigationCompleteAlreadyOccurred) {
                var selectedDate = new Date(dateTriplet[0], dateTriplet[1] - 1, dateTriplet[2]);
                var scheduler = $find("<%=RadScheduler1.ClientID %>");
                scheduler.set_selectedDate(selectedDate);
                _setHF(selectedDate);
                setShedulerStyles(scheduler);
            }

            SchedulerNavigationCompleteAlreadyOccurred = false;
            if (isPageLoaded)
                rebindGrid();
        }

        function RC_obdobi_OnDateSelected(sender, args) {
            var selectedDateTriplet = sender.get_selectedDates()[0];
            if (selectedDateTriplet) {

                var selectedDate = new Date(selectedDateTriplet[0], selectedDateTriplet[1] - 1, selectedDateTriplet[2]);
                var scheduler = $find("<%=RadScheduler1.ClientID %>");
                scheduler.set_selectedDate(selectedDate);
                _setHF(selectedDate);
            }
        }
        function _setHF(selectedDate) {
            var HF_sel_date = $get("<%=HF_sel_date.ClientID %>");
            HF_sel_date.value = "[" + selectedDate.format("yyyy") + "," + selectedDate.format("MM") + "," + selectedDate.format("dd") + "]";
        }
        function RC_obdobi_OnLoad(sender, args) {
            _bindScheduler = true;
            RC_obdobi_OnCalendarViewChanged(sender, args);
        }

        function RC_obdobi_OnInit(sender, args) {
        }
        function OnDblClickSpan(sender, id, i, datetrip) {
            var data = $find("<%=TRG_kalendar.ClientID %>").get_masterTableView().get_dataItems()[i].get_dataItem().RowData;
            var aptdata;
            data.some(function (element, index, array) {
                if (element.ID === id) {
                    aptdata = element;
                    return true;
                }
            });
            if (aptdata) {
                var apt = VytvorApt(aptdata);
                if (apt) {
                    var oschanged = false;
                    var os_cisla_list = KSMaster.getListOcCp();
                    apt.get_resources().forEach(function (element, index, array) {
                        if (element.get_type() === "Zamestnanci") {
                            if (KSMaster.addPairToOcCp(element.get_key(), -1, true)) {
                                oschanged = true;
                            }
                        }
                    });
                    if (oschanged) {
                        var callBack = function () {
                            afterOnDblClickSpan(apt, datetrip, oschanged, os_cisla_list);
                        };

                        KSMaster.saveListOcCpToGlobals(sender, null, callBack);
                    }
                    else {
                        afterOnDblClickSpan(apt, datetrip, oschanged, os_cisla_list);
                    }
                }
            }
        }
        //pokrakračování předchozí funkce, mezitím proběhlo uložení do globals
        function afterOnDblClickSpan(apt, datetrip, oschanged, os_cisla_list) {
            var scheduler = $find("<%=RadScheduler1.ClientID %>");
            var RTS = $find('<%=RadTabStrip1.ClientID %>');

            _bindScheduler = false;
            RTS.findTabByValue("shed").set_selected(true);
            scheduler.set_selectedView(Telerik.Web.UI.SchedulerViewType.DayView);
            scheduler.set_selectedDate(new Date(datetrip[0], datetrip[1], datetrip[2]));

            _bindScheduler = true;
            rebindScheduler();

            scheduler.showAdvancedEditForm(apt);

            if (oschanged) {
                KSMaster.setListOcCp(KSMaster.HF_sel_cislo_pom_list, os_cisla_list);
                KSMaster.saveListOcCpToGlobals();
            }
        }
        function getObdobiFirst(date) {
            var year = date.getFullYear();
            var month = date.getMonth();
            var date = 1;

            return new Date(year, month, date);
        }
        function getObdobiLast(date) {
            var year = date.getFullYear();
            var month = date.getMonth();
            var date = 1;

            int_d = new Date(year, month + 1, date);
            return new Date(int_d - 1);
        }
        function TRB_rebind_Clicked(sender, args) {
            rebindGrid(true);
        }
        function TRB_ch_CheckedChanged(sender, args) {
            var table = $find("<%=TRG_kalendar.ClientID %>");
            var masterTable = table.get_masterTableView();
            if (args.get_checked()) {
                masterTable.showFilterItem();
            }
            else {
                masterTable.clearFilter();
                masterTable.hideFilterItem();
            }
            resizeToFit(table);
        }

        function TRB_ch_primi_CheckedChanged(sender, args) {
            var newVal = args.get_checked() ? "true" : "false";
            var dispatch = KSMaster.HF_Globals_JenPrimePodrizene.value != newVal;
            KSMaster.HF_Globals_JenPrimePodrizene.value = newVal;

            rebindGrid(true);
            KSMaster._WSZloaded = false;
            KSMaster.loadSZ();

            if (dispatch) {
                document.dispatchEvent(KSMaster.jenPrimiPodrizeniChanged);
            }
        }

        function TRB_ch_primi_Load(sender, args) {
            KSMaster.HF_Globals_JenPrimePodrizene.value = sender.get_checked() ? "true" : "false";
        }
        var isExporting = false;
        var pagesize = 30;
        function TRB_ExportPdf_Clicked(sender, args) {
            var grid = $find("<%=TRG_kalendar.ClientID %>")
            var view = grid.get_masterTableView();

            pagesize = view.get_pageSize();
            isExporting = true;
            view.set_pageSize(10000);
        }

        function RadScheduler1_TimeSlotContextMenuItemClicked(sender, args) {
            var menuValue = args.get_item().get_value();
            var startTime = args.get_startSlot().get_startTime();
            var endTime = args.get_endSlot().get_endTime();


            if (menuValue.startsWith("CommandAddDchKod_")) {
                var kod = menuValue.split('CommandAddDchKod_')[1];
                _ajaxInsertDchKod(startTime, endTime, kod);
            }
            else if (KSMaster.PozadavekWindow) {
                if (endTime.getTime() == new Date(endTime.getFullYear(), endTime.getMonth(), endTime.getDate()).getTime()) {
                    endTime = endTime.addDays(-1);
                }
                if (menuValue == "CommandAddPozDovolena") {
                    KSMaster.PozadavekWindow.Show('dovol', startTime, endTime);
                }
                else if (menuValue == "CommandAddPozNahrVolno") {
                    KSMaster.PozadavekWindow.Show('nahrv', startTime, endTime);
                }
                else if (menuValue.startsWith("CommandAddPozAbsence_")) {
                    var kod = menuValue.split('CommandAddPozAbsence_')[1];
                    KSMaster.PozadavekWindow.Show('absence', startTime, endTime, kod);
                }
            }
        }

        function RadScheduler1_AppointmentContextMenuItemClicked(sender, args) {
            var menuValue = args.get_item().get_value();
            var apt = args.get_appointment();
            var aptAtrs = apt.get_attributes();
            var startTime = apt.get_start();
            var endTime = apt.get_end();

            if (menuValue == 'CommandDeleteAppointment') {
                sender.deleteAppointmentWithConfirmation(apt);
            }
            else if (KSMaster.PozadavekWindow) {
                var idPoz = aptAtrs.getAttribute('idPoz');
                var encq = aptAtrs.getAttribute('encq');
                if (endTime.getTime() == new Date(endTime.getFullYear(), endTime.getMonth(), endTime.getDate()).getTime()) {
                    endTime = endTime.addDays(-1);
                }
                if (menuValue == 'CommandOpenPoz' && idPoz) {
                    KSMaster.PozadavekWindow.Show(null, null, null, null, encq);
                }
                else {
                    var kod = aptAtrs.getAttribute('kod');
                    var zp = aptAtrs.getAttribute('zp');
                    var apts_stejny_kod;
                    if (kod && zp != 'p') {
                        apts_stejny_kod = sender.get_appointments().findByResource(apt.get_resources().getResourceByTypeAndKey('Kalendare', 'k_p_plan')).findAll(x => x.get_attributes().getAttribute('kod') == kod);
                        o_start_end = getStartEndFrom(startTime, endTime, apts_stejny_kod);
                        startTime = o_start_end.start;
                        endTime = o_start_end.end;
                    }
                    
                    if (menuValue == "CommandAddPozDovolena") {
                        KSMaster.PozadavekWindow.Show('dovol', startTime, endTime, zp);
                    }
                    else if (menuValue == "CommandAddPozNahrVolno") {
                        KSMaster.PozadavekWindow.Show('nahrv', startTime, endTime);
                    }
                    else if (menuValue.startsWith("CommandAddPozAbsence_")) {
                        var kod = menuValue.split('CommandAddPozAbsence_')[1];
                        KSMaster.PozadavekWindow.Show('absence', startTime, endTime, kod);
                    }
                }
            }
        }

        function getStartEndFrom(start, end, appts) {
            var d = getDayFromDateTime(start);
            var start_d = new Date(1);
            var current = false;
            var continues = false;
            var done = false;
            appts.forEach(apt => {
                if (!done) {
                    var curr_start = apt.get_start();
                    
                    continues = (getDayFromDateTime(curr_start) - start_d) <= (24 * 60 * 60 * 1000);

                    if (!continues && !current) {
                        start = curr_start;
                        end = apt.get_end();
                    }
                    if (continues) {
                        end = apt.get_end();
                    }
                    if (current && !continues) {
                        done = true;
                    }

                    start_d = getDayFromDateTime(curr_start);

                    if (getDayFromDateTime(curr_start).getTime() == d.getTime()) {
                        current = true;
                    }
                }
            });
            return {
                start: start,
                end: end
            }
        }

        function getDayFromDateTime(d) {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate())
        }

        function RadScheduler1_AppointmentContextMenu(sender, args) {
            var menuItems = sender.get_appointmentContextMenus()[0].get_items();
            menuItems.forEach(x => x.hide());

            var pravoEdit = KSMaster.HF_oc_akt_user_zast.value === KSMaster.HF_sel_os_cislo.value;

            var apt = args.get_appointment();
            var showDovIfInPast = new Date(new Date().toDateString()) < apt.get_end() || $get("<%=HF_pozDovInPast.ClientID %>").value == '0';
            var showAbsIfInPast = new Date(new Date().toDateString()) < apt.get_end() || $get("<%=HF_pozAbsInPast.ClientID %>").value == '0';
            var aptAtrs = apt.get_attributes();
            var res_plan = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'k_p_plan');
            if (res_plan && pravoEdit) {
                var kod = aptAtrs.getAttribute('kod');
                var typAbs = aptAtrs.getAttribute('typAbs');
                if (kod && typAbs == 'dov' && showDovIfInPast) {
                    menuItems.forEach(x => {
                        if (x.get_value() == 'CommandAddPozDovolena') {
                            x.show();
                        }
                    });
                }
                else if (kod && showAbsIfInPast) {
                    menuItems.forEach(x => {
                        if (x.get_value() == ('CommandAddPozAbsence_' + kod)) {
                            x.show();
                        }
                    });
                }
                menuItems.forEach(x => {
                    if (x.get_value() == ('CommandDeleteAppointment')) {
                        x.show();
                    }
                });
            }
            var res_poz_dovol = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'dovol');
            var res_poz_absence = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'absence');
            var res_poz_homeoff = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'homeoff');
            var res_poz_benef = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'benef');
            var res_poz_sluzc = apt.get_resources().getResourceByTypeAndKey('Kalendare', 'sluzc');
            if (res_poz_dovol || res_poz_absence || res_poz_sluzc || res_poz_homeoff || res_poz_benef) {
                menuItems.forEach(x => {
                    var menuValue = x.get_value();
                    if (menuValue == 'CommandOpenPoz' || (menuValue == 'CommandStornoPoz' && pravoEdit)) {
                        x.show();
                    }
                });
            }
        }

        function RadScheduler1_TimeSlotContextMenu(sender, args) {
            var menuItems = sender.get_timeSlotContextMenus()[0].get_items();
            menuItems.forEach(x => x.show());

            var pravoEdit = KSMaster.HF_oc_akt_user_zast.value === KSMaster.HF_sel_os_cislo.value;

            var slot = args.get_endSlot();
            var isNotPast = new Date(new Date().toDateString()) < slot.get_endTime();
            var showDovIfInPast = isNotPast || $get("<%=HF_pozDovInPast.ClientID %>").value == '0';
            var showAbsIfInPast = isNotPast || $get("<%=HF_pozAbsInPast.ClientID %>").value == '0';
            var showPlanIfInPast = isNotPast ;

            menuItems.forEach(x => {
                if (x.get_value() == 'CommandAddPozDovolena' && (!showDovIfInPast || !pravoEdit)) {
                    x.hide();
                }
                else if ((x.get_value()?.startsWith('CommandAddPozAbsence_') ?? false) && (!showDovIfInPast || !pravoEdit)) {
                    x.hide();
                }
                else if ((x.get_value()?.startsWith('CommandAddDchKod_') ?? false) && (!showPlanIfInPast || !pravoEdit)) {
                    x.hide();
                }
                else if (x.get_value() == 'CommandAddAppointment' && !pravoEdit) {
                    x.hide();
                }
            });
        }

        function _ajaxInsertDchKod(dt_od, dt_do, kod) {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + '/Dochazka/PlanovaniSmen.aspx/InsertFromCalendar',
                data:
                    "{" +
                        "json: '" +
                        "{ " +
                            "dt_od: [" + dt_od.getFullYear() + "," + (dt_od.getMonth() + 1) + "," + dt_od.getDate() + "," + dt_od.getHours() + "," + dt_od.getMinutes() + "], " +
                            "dt_do: [" + dt_do.getFullYear() + "," + (dt_do.getMonth() + 1) + "," + dt_do.getDate() + "," + dt_do.getHours() + "," + dt_do.getMinutes() + "], " +
                            "kod: " + kod +
                        "}'" +
                    "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                error: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                success: function (msg) {
                    if (msg && msg.d && msg.d.ErrorMessage) {
                        radalert(msg.d.ErrorMessage, 0, 0, msg.d.ErrorTitle, null, null);
                    }
                    rebindScheduler();
                }
            });
        }

        function rebindSumar(sender, args) {
            if (KSMaster.SumarDovoleneWindow && KSMaster.SumarDovoleneWindow.Grid) {
                KSMaster.SumarDovoleneWindow.Rebind();
            }
        }

        function RadScheduler1_AppointmentEditing(sender, args) {
            var apt = args.get_appointment();
            var res = apt.get_resources();
            var aptAtrs = apt.get_attributes();
            var resKey = res.getResourceByType('Kalendare').get_key();
            var idPoz = aptAtrs.getAttribute('idPoz');
            var encq = aptAtrs.getAttribute('encq');

            if (res.getResourceByTypeAndKey('Kalendare', 'k_p_plan') || idPoz)
                args.set_cancel(true);

            if (idPoz && encq) {
                KSMaster.PozadavekWindow.Show(null, null, null, null, encq);
            }
        }

    </script>
</telerik:RadScriptBlock>
<%--<telerik:RadFormDecorator ID="RadFormDecorator1" runat="server" DecorationZoneID="RadSplitter1" />--%>
<telerik:RadScriptBlock ID="RadScriptBlock2" runat="server">
    <script type="text/javascript">
        //<![CDATA[
        //Workaround:
        var removeCssClass = Sys.UI.DomElement.removeCssClass;
        Telerik.Web.UI.RadFormDecorator.prototype.set_elementDisabled = function (element, val) {
            var actor = element;
            var nextSibling = element.nextSibling;
            var type = element.type;

            if ((type == "checkbox" || type == "radio") && nextSibling && nextSibling.tagName == "LABEL") {
                actor = nextSibling;
            }
            else if (type == "button" || type == "reset" || type == "submit" || element.tagName == "BUTTON") {
                var parent = element.parentNode;
                if (parent && parent.tagName == "A") {
                    actor = parent;
                    parent.disabled = val;
                }
            }
            try {
                if (val) addCssClass(actor, "rfdInputDisabled");
                else removeCssClass(actor, "rfdInputDisabled");
            } catch (e) {
            }
            try {
                if (!val && $telerik.isIE && actor.parentNode.disabled) {
                    actor.parentNode.disabled = val;
                }
            } catch (e) {
            }
        }
        //]]>
    </script>
</telerik:RadScriptBlock>
<telerik:RadAjaxManagerProxy runat="server" ID="RadAjaxManagerProxy18">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRB_export">
            <UpdatedControls>
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="checkExportMailks">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="checkExportICS" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_kalendar">
            <UpdatedControls>
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadClientExportManager ID="RCEM_manager" runat="server"
    OnClientPdfExported="RCEM_manager_PdfExported">
    <PdfSettings PageBreakSelector=".pageBreak" MarginRight="10mm" Landscape="false" MarginBottom="10mm" MarginTop="10mm" MarginLeft="10mm" />
</telerik:RadClientExportManager>
<telerik:RadPersistenceManagerProxy ID="RPMP_cal_cont" runat="server">
    <PersistenceSettings>
        <telerik:PersistenceSetting ControlID="TRG_kalendar" />
    </PersistenceSettings>
</telerik:RadPersistenceManagerProxy>
<asp:Panel ID="P_HF" runat="server" CssClass="hidden">
</asp:Panel>
<telerik:RadAjaxLoadingPanel ID="RadAjaxLoadingPanel1" runat="server" Transparency="30">
    <div class="loader" style="position: fixed">
        <div class="inner one"></div>
        <div class="inner two"></div>
        <div class="inner three"></div>
    </div>
</telerik:RadAjaxLoadingPanel>
<%--<telerik:RadButton ID="RadButton1" runat="server" Text="RadButton" OnClick="RadButton1_Click">
</telerik:RadButton>--%>
<asp:ObjectDataSource ID="ODS_kal" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="TypyKalendaru" TypeName="KSProgram.Reminder.ZamKalendar">
    <SelectParameters>
        <asp:Parameter Type="Boolean" Name="pravaAkceProhl" DefaultValue="true" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_poz" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="TypyPozadavku" TypeName="KSProgram.Reminder.ZamKalendar">
    <SelectParameters>
        <asp:Parameter Type="Boolean" Name="pravaAkceProhl" DefaultValue="true" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:HiddenField ID="HF_sel_date" runat="server" />
<asp:HiddenField ID="HF_svatky" runat="server" />
<asp:HiddenField ID="HF_kalendareCheckedState" runat="server" />
<asp:HiddenField ID="HF_pozadavkyCheckedState" runat="server" />
<asp:HiddenField ID="HF_stavyPoz" runat="server" />
<asp:HiddenField ID="HF_pozDovInPast" runat="server" />
<asp:HiddenField ID="HF_pozAbsInPast" runat="server" />
<telerik:RadTabStrip ID="RadTabStrip1" runat="server" MultiPageID="RadMultiPage1" CssClass="rts-RadTabStrip1"
    OnClientTabSelected="RadTabStrip1_TabSelected" SelectedIndex="0" CausesValidation="false">
    <Tabs>
        <telerik:RadTab PageViewID="RPV_Sheduler" Text="[%Kalendář%]" PostBack="False"
            Selected="true" Value="shed">
        </telerik:RadTab>
        <telerik:RadTab PageViewID="RPV_Grid" Text="[%Seznam%]" PostBack="False" Value="grid">
        </telerik:RadTab>
    </Tabs>
</telerik:RadTabStrip>
<telerik:RadSplitter ID="RadSplitter1" runat="server" Width="100%" Height="100%" CssClass="kc-main-splitter"
    SplitBarsSize="" BackColor="white">
    <telerik:RadPane ID="RadPane1" runat="server" Width="220" MinWidth="220" Scrolling="None">
        <telerik:RadSplitter ID="RadSplitter2" runat="server" Height="100%" Width="100%"
            Orientation="Horizontal">
            <telerik:RadPane ID="RadPane3" runat="server" Scrolling="None" Height="252px" BackColor="White">
                <kspwc:TRadCalendar runat="server" ID="RC_obdobi" EnableMultiSelect="false" DayNameFormat="FirstTwoLetters"
                    EnableNavigation="true" EnableMonthYearFastNavigation="true">
                    <ClientEvents OnCalendarViewChanged="RC_obdobi_OnCalendarViewChanged" OnDateSelected="RC_obdobi_OnDateSelected"
                        OnLoad="RC_obdobi_OnLoad" OnInit="RC_obdobi_OnInit" />
                </kspwc:TRadCalendar>
            </telerik:RadPane>
            <telerik:RadSplitBar ID="RadSplitbar2" runat="server" CollapseMode="Forward" EnableResize="false">
            </telerik:RadSplitBar>
            <telerik:RadPane ID="RadPane4" runat="server" Scrolling="Y">
                <telerik:RadPanelBar runat="server" ID="RPB_typy_kal" Width="100%" CssClass="rpTempPadd">
                    <Items>
                        <telerik:RadPanelItem Text="[%Kalendáře%]" Expanded="True" Selected="true">
                            <ContentTemplate>
                                <div class="ksKalTempl">
                                    <asp:Repeater ID="R_kal" runat="server" DataSourceID="ODS_kal">
                                        <ItemTemplate>
                                            <asp:Panel ID="P_kal" runat="server" CssClass="kalItem">
                                                <input id="chkKalendar<%# Eval("Value") %>" type="checkbox" onclick="rebindScheduler(true)"
                                                    value='<%# Eval("Value") %>' />
                                            </asp:Panel>
                                            <telerik:RadScriptBlock ID="RSB_k" runat="server">
                                                <script type="text/javascript">
                                                    $('#chkKalendar<%# Eval("Value") %>').kendoCheckBox({
                                                        label: '<%# Eval("Text") %>',
                                                    });
                                                </script>
                                            </telerik:RadScriptBlock>
                                            <style type="text/css">
                                                #chkKalendar<%# Eval("Value") %> {
                                                    background-color: <%# Eval("CssColor") %>;
                                                    border-color: <%# Eval("CssColor") %>;
                                                    color: <%# Eval("CssColorText") %>;
                                                }
                                            </style>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </div>
                            </ContentTemplate>
                        </telerik:RadPanelItem>
                        <telerik:RadPanelItem Text="[%Požadavky%]" Expanded="True" Selected="true">
                            <ContentTemplate>
                                <div class="ksKalTempl ksPoz">
                                    <asp:Repeater ID="R_poz" runat="server" DataSourceID="ODS_poz">
                                        <ItemTemplate>
                                            <asp:Panel ID="P_poz" runat="server" CssClass="kalItem">
                                                <input id="chkPozadavek<%# Eval("Value") %>" type="checkbox" onclick="rebindScheduler(true)"
                                                    value='<%# Eval("Value") %>' />
                                            </asp:Panel>
                                            <telerik:RadScriptBlock ID="RSB_p" runat="server">
                                                <script type="text/javascript">
                                                    $('#chkPozadavek<%# Eval("Value") %>').kendoCheckBox({
                                                        label: '<%# Eval("Text") %>'
                                                    });
                                                </script>
                                            </telerik:RadScriptBlock>
                                            <style type="text/css">
                                                #chkPozadavek<%# Eval("Value") %> {
                                                    background-color: <%# Eval("CssColor") %>;
                                                    border-color: <%# Eval("CssColor") %>;
                                                    color: <%# Eval("CssColorText") %>;
                                                }
                                            </style>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </div>
                                <div class="ksKalTempl">
                                    <div runat="server" id="P_stav_n" class="kalItem">
                                        <input id="chkTypPozN" class="chkTypPoz" type="checkbox" onclick="rebindScheduler(true)" value='n'/>
                                    </div>
                                    <div runat="server" id="P_stav_r" class="kalItem">
                                        <input id="chkTypPozR" class="chkTypPoz" type="checkbox" onclick="rebindScheduler(true)" value='r'/>
                                    </div>
                                    <div runat="server" id="P_stav_s" class="kalItem">
                                        <input id="chkTypPozS" class="chkTypPoz" type="checkbox" onclick="rebindScheduler(true)" value='s' />
                                    </div>
                                    <div runat="server" id="P_stav_o" class="kalItem">
                                        <input id="chkTypPozO" class="chkTypPoz" type="checkbox" onclick="rebindScheduler(true)" value='o' />
                                    </div>
                                    <telerik:RadScriptBlock ID="RSB_s" runat="server">
                                        <script type="text/javascript">
                                            $('#chkTypPozN').kendoCheckBox({
                                                label: '[%Nový%]'
                                            });
                                            $('#chkTypPozR').kendoCheckBox({
                                                label: '[%Běžící%]'
                                            });
                                            $('#chkTypPozS').kendoCheckBox({
                                                label: '[%Zamítnutý%]'
                                            });
                                            $('#chkTypPozO').kendoCheckBox({
                                                label: '[%Schválený%]'
                                            });
                                        </script>
                                    </telerik:RadScriptBlock>
                                    <style type="text/css">
                                        input.chkTypPoz {
                                            background-color: #CCCCCC;
                                            border-color: #CCCCCC;
                                        }
                                    </style>
                                </div>
                            </ContentTemplate>
                        </telerik:RadPanelItem>
                    </Items>
                </telerik:RadPanelBar>
                <table style="width: 100%">
                    <tr>
                        <td>
                            <asp:CheckBox runat="server" ID="checkExportICS" Enabled="false" />
                        </td>
                        <td>

                            <kspwc:TRadButton Width="100%" ID="checkExportMailks" runat="server" Text="[%Zasílat ICS emailem%]" OnClick="checkExportMailks_CheckedChanged"></kspwc:TRadButton>
                        </td>
                    </tr>
                </table>
                <asp:Panel ID="P_export" runat="server">
                    <table>
                        <tr>
                            <td>
                                <kspwc:TRadButton ID="TRB_export" runat="server" Text="iCalendar Export" OnCommand="TRB_export_OnCommand"
                                    CssClass="no-block-ui" CausesValidation="false">
                                </kspwc:TRadButton>
                            </td>
                            <td>
                                <kspwc:TRadComboBox ID="TRCB_export_delka_obdobi" runat="server" Width="90" DropDownAutoWidth="Enabled">
                                    <Items>
                                        <telerik:RadComboBoxItem Text="[%Týden%]" Value="t" />
                                        <telerik:RadComboBoxItem Text="[%Měsíc%]" Selected="True" Value="m" />
                                        <telerik:RadComboBoxItem Text="[%Rok%]" Value="r" />
                                    </Items>
                                </kspwc:TRadComboBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </telerik:RadPane>
        </telerik:RadSplitter>
    </telerik:RadPane>
    <telerik:RadSplitBar ID="RadSplitbar1" runat="server" CollapseMode="Forward" EnableResize="false">
    </telerik:RadSplitBar>
    <telerik:RadPane ID="Radpane2" runat="server" Width="100%" OnClientResized="RadPane2_Resized">
        <telerik:RadMultiPage ID="RadMultiPage1" runat="server" SelectedIndex="0" Height="100%" Width="100%">
            <telerik:RadPageView ID="RPV_Sheduler" runat="server" Selected="true" Height="100%" Width="100%">
                <telerik:RadScheduler runat="server" ID="RadScheduler1" RenderMode="Lightweight" Height="100%" Width="100%" OverflowBehavior="Expand"
                    SelectedView="MonthView" FirstDayOfWeek="Monday" LastDayOfWeek="Sunday" EnableDescriptionField="True"
                    OnResourcesPopulating="RadScheduler1_ResourcesPopulating" 
                    OnDataBound="RadScheduler1_DataBound"

                    OnClientResourcesPopulating="RS1_ResourcesPopulating"
                    OnClientAppointmentsPopulating="RadScheduler1_AppointmentsPopulating" 
                    OnClientAppointmentsPopulated="RadScheduler1_AppointmentsPopulated"
                    OnClientDataBound="RS_DataBound"
                    OnClientTimeSlotContextMenuItemClicking="RadScheduler1_ContextMenuItemClicking"
                    OnClientRequestFailed="RadScheduler1_RequestFailed" 
                    OnClientRequestSuccess="RadScheduler1_RequestSuccess"
                    OnClientAppointmentDataBound="OnClientAppointmentDataBound" 
                    OnClientFormCreated="schedulerFormCreated" 
                    OnClientNavigationComplete="RadScheduler1_NavigationComplete"
                    OnClientTimeSlotContextMenuItemClicked="RadScheduler1_TimeSlotContextMenuItemClicked"
                    OnClientTimeSlotContextMenu="RadScheduler1_TimeSlotContextMenu"
                    OnClientAppointmentContextMenuItemClicked="RadScheduler1_AppointmentContextMenuItemClicked"
                    OnClientAppointmentContextMenu="RadScheduler1_AppointmentContextMenu"
                    OnClientAppointmentCreated="RadScheduler1_AppointmentCreated"
                    OnClientAppointmentEditing="RadScheduler1_AppointmentEditing"

                    AppointmentStyleMode="Default" 
                    DayStartTime="06:00:00" EnableRecurrenceSupport="True" CssClass="ksRadSheduler"
                    WorkDayEndTime="18:00:00" WorkDayStartTime="06:00:00" ShowAllDayRow="True"
                    ShowFullTime="False" RowHeight="25px" HoursPanelTimeFormat="H:mm"
                    StartInsertingInAdvancedForm="true" StartEditingInAdvancedForm="true">
                    <AdvancedForm EnableTimeZonesEditing="false" />
                    <ExportSettings>
                        <Pdf PageBottomMargin="1in" PageLeftMargin="1in" PageRightMargin="1in" PageTopMargin="1in" />
                    </ExportSettings>
                    <AdvancedForm Enabled="True" Modal="true" EnableTimeZonesEditing="true" />
                    <ResourceTypes>
                        <telerik:ResourceType KeyField="Kalendare" Name="Kalendare" TextField="Kalendář" />
                        <telerik:ResourceType AllowMultipleValues="True" KeyField="Zamestnanci" Name="Zamestnanci"
                            TextField="Zaměstnanec" />
                    </ResourceTypes>
                    <Reminders Enabled="false" />
                    <DayView DayStartTime="06:00:00" UserSelectable="true" />
                    <WeekView HeaderDateFormat="D" />
                    <MonthView UserSelectable="true" VisibleAppointmentsPerDay="6" HeaderDateFormat="MMMM, yyyy" FirstDayHeaderDateFormat="d. MMMM" ColumnHeaderDateFormat="dddd" DayHeaderDateFormat="d." />
                    <AgendaView UserSelectable="true" HeaderDateFormat="D" />
                    <TimelineView UserSelectable="false" HeaderDateFormat="D" />
                    <MultiDayView UserSelectable="false" />
                    <YearView UserSelectable="true" />
                    <WebServiceSettings Path="~/PrivateWebServices/SchedulerWebService.asmx" ResourcePopulationMode="ClientSide">
                    </WebServiceSettings>
                    <AdvancedInsertTemplate>
                        <scheduler:AdvancedForm runat="server" ID="AdvancedInsertForm1" Mode="Insert" />
                    </AdvancedInsertTemplate>
                    <AdvancedEditTemplate>
                        <scheduler:AdvancedForm ID="AdvancedEditForm1" runat="server" Mode="Edit" />
                    </AdvancedEditTemplate>
                    <Localization HeaderYear="[%Rok%]" />
                    <TimeSlotContextMenus>
                        <telerik:RadSchedulerContextMenu runat="server" ID="RSCM_TimeSlotMenu">
                        </telerik:RadSchedulerContextMenu>
                    </TimeSlotContextMenus>
                    <AppointmentContextMenuSettings  />
                    <AppointmentContextMenus>
                        <telerik:RadSchedulerContextMenu runat="server" ID="RSCM_AppointmentMenu">
                        </telerik:RadSchedulerContextMenu>
                    </AppointmentContextMenus>
                </telerik:RadScheduler>
            </telerik:RadPageView>
            <telerik:RadPageView ID="RPV_Grid" runat="server" Height="100%" Width="100%">
                <%--<asp:Panel ID="P_Grid" runat="server" Height="100%">--%>
                <kspwc:TRadGrid ID="TRG_kalendar" runat="server" AllowPaging="True" AllowSorting="True"
                    AutoGenerateColumns="False" AutoFilterControlWidth="false" AutoFilterWidth="true"
                    AllowFilteringByColumn="True" Height="100%" Width="100%"
                    CssClass="GridNoBorder trg-kalendar" IsExporting="False"
                    OnExportCellFormatting="TRG_kalendar_ExportCellFormatting"
                    OnInfrastructureExporting="TRG_kalendar_InfrastructureExporting"
                    OnHTMLExporting="TRG_kalendar_HTMLExporting"
                    OnGridExporting="TRG_kalendar_GridExporting"
                    OnItemDataBound="TRG_kalendar_ItemDataBound">
                    <ExportSettings>
                        <Excel AutoFitColumnWidth="AutoFitAll" />
                    </ExportSettings>
                    <ClientSettings>
                        <ClientEvents 
                            OnDataBinding="TRG_kalendar_OnDataBinding" 
                            OnDataBound="TRG_kalendar_OnDataBound"
                            OnGridCreated="TRG_kalendar_OnGridCreated" 
                            OnRowDataBound="TRG_kalendar_OnRowDataBound" />
                        <Scrolling AllowScroll="True" UseStaticHeaders="true" FrozenColumnsCount="2" SaveScrollPosition="false" />
                        <DataBinding FilterParameterType="Linq" Location="../PrivateWebServices/SchedulerWebService.asmx"
                            SelectMethod="GetKalendareZamestnancu" ShowEmptyRowsOnLoad="False" SortParameterType="Linq">
                        </DataBinding>
                        <Resizing AllowColumnResize="True" AllowResizeToFit="True" EnableRealTimeResize="False"
                            ResizeGridOnColumnResize="False" />
                    </ClientSettings>
                    <MasterTableView CommandItemDisplay="Top" EnableHeaderContextMenu="False" PageSize="30" CssClass="pdfExport">
                        <PagerStyle AlwaysVisible="True" PageSizes="10;20;30;50;100" />
                        <CommandItemTemplate>
                            <table>
                                <tr>
                                    <td>
                                        <kspwc:GridCommandItemControl ID="TGridCommandItemControl1" runat="server">
                                            <FilterButton ID="FilterButton1" runat="server" AutoPostBack="False" OnClientCheckedChanged="TRB_ch_CheckedChanged">
                                            </FilterButton>
                                            <PrimiPodrizeniButton ID="PrimiPodrizeniButton1" runat="server" AutoPostBack="False"
                                                OnClientCheckedChanged="TRB_ch_primi_CheckedChanged" OnClientLoad="TRB_ch_primi_Load"
                                                Visible="true">
                                            </PrimiPodrizeniButton>
                                            <RebindButton ID="RebindButton1" runat="server" AutoPostBack="False" OnClientClicked="TRB_rebind_Clicked">
                                            </RebindButton>
                                            <ExportButton runat="server" ID="TRG_kalendar_Export_Button" Visible="True" ShowExportToCsvItem="false"
                                                ShowExportToExcelBIFFItem="false" ShowExportToExcelMLItem="false" ShowExportToExcelXlsxItem="false"
                                                ShowExportToPdfItem="false" ShowExportToWordDocxItem="false">
                                            </ExportButton>
                                        </kspwc:GridCommandItemControl>
                                    </td>
                                    <td>
                                        <kspwc:TRadButton ID="TRB_ExportPdf" runat="server" AutoPostBack="False" Text="[%Export do PDF%]"
                                            OnClientClicked="TRB_ExportPdf_Clicked" CssClass="hidden">
                                        </kspwc:TRadButton>
                                    </td>
                                </tr>
                            </table>
                        </CommandItemTemplate>
                        <Columns>
                            <telerik:GridNumericColumn DataField="OsCislo" DataType="System.Decimal" DecimalDigits="0"
                                FilterControlAltText="Filter OsCislo column" HeaderText="[%Os. číslo%]"
                                UniqueName="OsCislo">
                            </telerik:GridNumericColumn>
                            <telerik:GridBoundColumn DataField="Jmeno" FilterControlAltText="Filter Jmeno column"
                                HeaderText="[%Jméno%]" UniqueName="Jmeno">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="kmen_str_cislo" FilterControlAltText="Filter kmen_str_cislo column"
                                HeaderText="[%Číslo%]" UniqueName="kmen_str_cislo">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="kmen_str" FilterControlAltText="Filter kmen_str column"
                                HeaderText="[%Název střediska%]" UniqueName="kmen_str">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="cis_pracmist" FilterControlAltText="Filter cis_pracmist column"
                                HeaderText="[%Číslo místa%]" UniqueName="cis_pracmist">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="naz_pracmist" FilterControlAltText="Filter naz_pracmist column"
                                HeaderText="[%Název místa%]" UniqueName="naz_pracmist">
                            </telerik:GridBoundColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d1" DataType="System.Int32"
                                FilterControlAltText="Filter d1 column" SortExpression="d1" UniqueName="d1" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    1
                                    <br />
                                    <kspwc:TLabel ID="L_h1" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <%--<input name="HF_RowData_#= OsCislo #" id="HF_RowData_#= OsCislo #" type="hidden"/>--%>
                                        <div class="dayCell" id="holder_#= OsCislo #_d1"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d2" DataType="System.Int32"
                                FilterControlAltText="Filter d2 column" SortExpression="d2" UniqueName="d2" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    2
                                    <br />
                                    <kspwc:TLabel ID="L_h2" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d2"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d3" DataType="System.Int32"
                                FilterControlAltText="Filter d3 column" SortExpression="d3" UniqueName="d3" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    3
                                    <br />
                                    <kspwc:TLabel ID="L_h3" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d3"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d4" DataType="System.Int32"
                                FilterControlAltText="Filter d4 column" SortExpression="d4" UniqueName="d4" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    4
                                    <br />
                                    <kspwc:TLabel ID="L_h4" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d4"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d5" DataType="System.Int32"
                                FilterControlAltText="Filter d5 column" SortExpression="d5" UniqueName="d5" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    5
                                    <br />
                                    <kspwc:TLabel ID="L_h5" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d5"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d6" DataType="System.Int32"
                                FilterControlAltText="Filter d6 column" SortExpression="d6" UniqueName="d6" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    6
                                    <br />
                                    <kspwc:TLabel ID="L_h6" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d6"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d7" DataType="System.Int32"
                                FilterControlAltText="Filter d7 column" SortExpression="d7" UniqueName="d7" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    7
                                    <br />
                                    <kspwc:TLabel ID="L_h7" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d7"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d8" DataType="System.Int32"
                                FilterControlAltText="Filter d8 column" SortExpression="d8" UniqueName="d8" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    8
                                    <br />
                                    <kspwc:TLabel ID="L_h8" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d8"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d9" DataType="System.Int32"
                                FilterControlAltText="Filter d9 column" SortExpression="d9" UniqueName="d9" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    9
                                    <br />
                                    <kspwc:TLabel ID="L_h9" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d9"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d10" DataType="System.Int32"
                                FilterControlAltText="Filter d10 column" SortExpression="d10" UniqueName="d10" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    10
                                    <br />
                                    <kspwc:TLabel ID="L_h10" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d10"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d11" DataType="System.Int32"
                                FilterControlAltText="Filter d11 column" SortExpression="d11" UniqueName="d11" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    11
                                    <br />
                                    <kspwc:TLabel ID="L_h11" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d11"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d12" DataType="System.Int32"
                                FilterControlAltText="Filter d12 column" SortExpression="d12" UniqueName="d12" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    12
                                    <br />
                                    <kspwc:TLabel ID="L_h12" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d12"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d13" DataType="System.Int32"
                                FilterControlAltText="Filter d13 column" SortExpression="d13" UniqueName="d13" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    13
                                    <br />
                                    <kspwc:TLabel ID="L_h13" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d13"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d14" DataType="System.Int32"
                                FilterControlAltText="Filter d14 column" SortExpression="d14" UniqueName="d14" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    14
                                    <br />
                                    <kspwc:TLabel ID="L_h14" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d14"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d15" DataType="System.Int32"
                                FilterControlAltText="Filter d15 column" SortExpression="d15" UniqueName="d15" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    15
                                    <br />
                                    <kspwc:TLabel ID="L_h15" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d15"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d16" DataType="System.Int32"
                                FilterControlAltText="Filter d16 column" SortExpression="d16" UniqueName="d16" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    16
                                    <br />
                                    <kspwc:TLabel ID="L_h16" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d16"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d17" DataType="System.Int32"
                                FilterControlAltText="Filter d17 column" SortExpression="d17" UniqueName="d17" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    17
                                    <br />
                                    <kspwc:TLabel ID="L_h17" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d17"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d18" DataType="System.Int32"
                                FilterControlAltText="Filter d18 column" SortExpression="d18" UniqueName="d18" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    18
                                    <br />
                                    <kspwc:TLabel ID="L_h18" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d18"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d19" DataType="System.Int32"
                                FilterControlAltText="Filter d19 column" SortExpression="d19" UniqueName="d19" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    19
                                    <br />
                                    <kspwc:TLabel ID="L_h19" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d19"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d20" DataType="System.Int32"
                                FilterControlAltText="Filter d20 column" SortExpression="d20" UniqueName="d20" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    20
                                    <br />
                                    <kspwc:TLabel ID="L_h20" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d20"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d21" DataType="System.Int32"
                                FilterControlAltText="Filter d21 column" SortExpression="d21" UniqueName="d21" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    21
                                    <br />
                                    <kspwc:TLabel ID="L_h21" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d21"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d22" DataType="System.Int32"
                                FilterControlAltText="Filter d22 column" SortExpression="d22" UniqueName="d22" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    22
                                    <br />
                                    <kspwc:TLabel ID="L_h22" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d22"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d23" DataType="System.Int32"
                                FilterControlAltText="Filter d23 column" SortExpression="d23" UniqueName="d23" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    23
                                    <br />
                                    <kspwc:TLabel ID="L_h23" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d23"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d24" DataType="System.Int32"
                                FilterControlAltText="Filter d24 column" SortExpression="d24" UniqueName="d24" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    24
                                    <br />
                                    <kspwc:TLabel ID="L_h24" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d24"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d25" DataType="System.Int32"
                                FilterControlAltText="Filter d25 column" SortExpression="d25" UniqueName="d25" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    25
                                    <br />
                                    <kspwc:TLabel ID="L_h25" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d25"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d26" DataType="System.Int32"
                                FilterControlAltText="Filter d26 column" SortExpression="d26" UniqueName="d26" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    26
                                    <br />
                                    <kspwc:TLabel ID="L_h26" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d26"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d27" DataType="System.Int32"
                                FilterControlAltText="Filter d27 column" SortExpression="d27" UniqueName="d27" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    27
                                    <br />
                                    <kspwc:TLabel ID="L_h27" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d27"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d28" DataType="System.Int32"
                                FilterControlAltText="Filter d28 column" SortExpression="d28" UniqueName="d28" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    28
                                    <br />
                                    <kspwc:TLabel ID="L_h28" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d28"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d29" DataType="System.Int32"
                                FilterControlAltText="Filter d29 column" SortExpression="d29" UniqueName="d29" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    29
                                    <br />
                                    <kspwc:TLabel ID="L_h29" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d29"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d30" DataType="System.Int32"
                                FilterControlAltText="Filter d30 column" SortExpression="d30" UniqueName="d30" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    30
                                    <br />
                                    <kspwc:TLabel ID="L_h30" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d30"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn AllowFiltering="False" DataField="d31" DataType="System.Int32"
                                FilterControlAltText="Filter d31 column" SortExpression="d31" UniqueName="d31" HeaderStyle-CssClass="dayHeader">
                                <HeaderTemplate>
                                    31
                                    <br />
                                    <kspwc:TLabel ID="L_h31" runat="server"></kspwc:TLabel>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                                        <div class="dayCell" id="holder_#= OsCislo #_d31"></div>
                                </ClientItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
                <%--</asp:Panel>--%>
            </telerik:RadPageView>
        </telerik:RadMultiPage>
    </telerik:RadPane>
</telerik:RadSplitter>
        <ucsum:Sumar runat="server" ID="S_Sumar"></ucsum:Sumar>
<%--<telerik:RadScheduler ID="RS_GridForm" runat="server" CssClass="hidden">
    <ResourceTypes>
        <telerik:ResourceType TextField="Kalendář" Name="Kalendare" KeyField="Kalendare" />
        <telerik:ResourceType TextField="Zaměstnanec" Name="Zamestnanci" KeyField="Zamestnanci"
            AllowMultipleValues="True" />
    </ResourceTypes>
    <AdvancedEditTemplate>
        <scheduler:AdvancedForm runat="server" ID="AdvancedEditForm2" Mode="ReadOnly" />
    </AdvancedEditTemplate>
    <AdvancedInsertTemplate>
        <scheduler:AdvancedForm runat="server" ID="AdvancedInsertForm2" Mode="ReadOnly" />
    </AdvancedInsertTemplate>
</telerik:RadScheduler>--%>
