﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="KvalifikacniKartaControl"
    CodeBehind="KvalifKartaControl.ascx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    .KsUnderlineTable {
        padding: 5px;
        border-collapse: initial !important;
    }

    .kszahlavi {
        padding: 20px;
        text-align: center;
    }
</style>
<telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
        //<![CDATA[
        function TRG_ziskana_osvedceni_OnColumnHidden(sender, args) {
            if (args._gridColumn._owner.get_name() != 'detail') {
                VisibilityDetailCollumns(sender);
            }
        }
        function TRG_ziskana_osvedceni_OnColumnShown(sender, args) {
            if (args._gridColumn._owner.get_name() != 'detail') {
                VisibilityDetailCollumns(sender);
            }
        }
        function TRG_ziskana_osvedceni_OnGridCreated(sender, args) {
            VisibilityDetailCollumns(sender);
        }
        function VisibilityDetailCollumns(sender) {
            var masterView = sender.get_masterTableView();
            var datilViews = sender.get_detailTables();
            for (deti in datilViews) {
                var datilView = datilViews[deti];
                var detailColls = datilView.get_columns();
                for (coli in detailColls) {
                    var dcoll = detailColls[coli];
                    var name = dcoll.get_uniqueName();
                    var mcoll = masterView.getColumnByUniqueName(name.substr(1, name.length - 1));
                    if (mcoll) {
                        if (mcoll.get_visible() != dcoll.get_visible()) {
                            if (dcoll.get_visible()) {
                                datilView.hideColumn(coli);
                            }
                            else {
                                datilView.showColumn(coli);
                            }
                        }
                    }
                }
            }
        }
        function TRG_ziskana_osvedceni_OnHierarchyExpanding(sender, args) {
            args.set_cancel(args.get_gridDataItem().get_element().getElementsByClassName("rgExpandCol")[0].innerHTML == " ");
        }

//]]>
    </script>
</telerik:RadCodeBlock>
<telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server"
    UniqueKey="">
    <PersistenceSettings>
        <telerik:PersistenceSetting ControlID="TRG_ziskana_osvedceni" />
    </PersistenceSettings>
</telerik:RadPersistenceManagerProxy>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="cbVazbaNaIndPlan">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="cbVazbaNaIndPlan" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_ziskana_osvedceni" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_ziskana_osvedceni">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="cbVazbaNaIndPlan" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_ziskana_osvedceni" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<asp:Label ID="Label5" runat="server" CssClass="nadpis1" Text="[%Kvalifikační karta zaměstnance%]"></asp:Label>
<table>
    <tr>
        <td valign="top" style="padding-right: 10px">
            <asp:ObjectDataSource ID="ODS_PozadVzdel" runat="server" SelectMethod="PozadVzdelAPraxe"
                TypeName="KSProgram.Vzdelavani.KvalifikacniKarta"></asp:ObjectDataSource>
            <cc1:TDataList ID="DataList1" runat="server" DataSourceID="ODS_PozadVzdel" RepeatDirection="Horizontal" CssClass="ksprvek">
                <ItemTemplate>
                    <cc1:BindTable ID="BindTable1" runat="server" HeaderText="[%Požadované vzdělání%]"
                        Width="100%" TextFieldWidth="100px">
                        <Rows>
                            <cc1:BindRow DataField="stupen" Text="[%Stupeň vzdělání%]" />
                            <cc1:BindRow DataField="obor" Text="[%Obor%]" />
                            <cc1:BindRow DataField="skupina_oboru" Text="[%Skupina oborů%]" />
                            <cc1:BindRow DataField="praxe" Text="[%Praxe%]" />
                        </Rows>
                    </cc1:BindTable>
                    <cc1:BindTable ID="BindTable3" runat="server" HeaderText="[%Výjimka%]" Width="100%"
                        TextFieldWidth="100px">
                        <Rows>
                            <cc1:BindRow DataField="vyjimka_od" Text="[%Datum od%]" DataFormatString="{0:d}" />
                            <cc1:BindRow DataField="vyjimka_do" Text="[%Datum do%]" DataFormatString="{0:d}" />
                            <cc1:BindRow DataField="vyjimka_povolil" Text="[%Povolil%]" />
                        </Rows>
                    </cc1:BindTable>
                </ItemTemplate>
                <HeaderTemplate>
                    <asp:Label runat="server" ID="xx1" Text="[%Požadované vzdělání a praxe%]"></asp:Label>
                </HeaderTemplate>
            </cc1:TDataList>
        </td>
        <td valign="top">
            <asp:ObjectDataSource ID="ODS_MaxVzdel" runat="server" SelectMethod="MaxVzdelani"
                TypeName="KSProgram.Vzdelavani.KvalifikacniKarta"></asp:ObjectDataSource>
            <cc1:TDataList ID="TDataList1" runat="server" DataSourceID="ODS_MaxVzdel" CssClass="ksprvek">
                <HeaderTemplate>
                    <asp:Label runat="server" ID="xx2" Text="[%Nejvyšší dosažené vzdělání%]"></asp:Label>
                </HeaderTemplate>
                <ItemTemplate>
                    <cc1:BindTable ID="BindTable2" runat="server">
                        <Rows>
                            <cc1:BindRow />
                            <cc1:BindRow DataField="stupen" Text="[%Stupeň%]" />
                            <cc1:BindRow DataField="obor" Text="[%Obor%]" />
                            <cc1:BindRow DataField="druh_zkousky" Text="[%Druh zkoušky%]" />
                            <cc1:BindRow DataField="rok_ukonc" Text="[%Rok ukončení%]" />
                            <cc1:BindRow DataField="skola" Text="[%Škola%]" />
                        </Rows>
                    </cc1:BindTable>
                </ItemTemplate>
            </cc1:TDataList>
        </td>
    </tr>
</table>
<br />
<cc1:TCheckBox ID="cbVazbaNaIndPlan" runat="server" AutoPostBack="True" Text="[%Provázat získané vzdělávací aktivity s časovostí aktuálního individuálního plánu vzdělávání%]"
    Visible="False" UseSaveSetting="True" OnCheckedChanged="cbVazbaNaIndPlan_CheckedChanged" CssClass="pozadiText" />
<cc1:TRadGrid ID="TRG_ziskana_osvedceni" runat="server" OnNeedDataSource="TRG_ziskana_osvedceni_NeedDataSource" EnableHeaderContextMenu="true"
    GroupPanelPosition="Top" OnDetailTableDataBind="TRG_ziskana_osvedceni_DetailTableDataBind"
    ShowGroupPanel="True" AllowMultiColumnSorting="True"
    AllowSorting="True" OnPreRender="TRG_ziskana_osvedceni_PreRender" OnItemCreated="TRG_ziskana_osvedceni_ItemCreated"
    AutoGenerateColumns="False" OnItemDataBound="TRG_ziskana_osvedceni_ItemDataBound"
    OnItemCommand="TRG_ziskana_osvedceni_ItemCommand">
    <GroupingSettings ShowUnGroupButton="True" />
    <ClientSettings AllowDragToGroup="True">
        <ClientEvents OnColumnHidden="TRG_ziskana_osvedceni_OnColumnHidden" OnColumnShown="TRG_ziskana_osvedceni_OnColumnShown"
            OnGridCreated="TRG_ziskana_osvedceni_OnGridCreated" OnHierarchyExpanding="TRG_ziskana_osvedceni_OnHierarchyExpanding" />
    </ClientSettings>
    <MasterTableView DataKeyNames="id,cis_osve" EnableGroupsExpandAll="True" EnableHierarchyExpandAll="true"
        GroupLoadMode="Client" HierarchyLoadMode="Client" CommandItemDisplay="Top" ShowFooter="True"
        EnableHeaderContextAggregatesMenu="True" EnableHeaderContextFilterMenu="True"
        EnableHeaderContextMenu="True" AllowPaging="True" PageSize="20" Caption="[%Vzdělávací aktivita%]">
        <DetailTables>
            <telerik:GridTableView runat="server" Name="detail" EnableHeaderContextMenu="False"
                EnableHeaderContextAggregatesMenu="False" EnableHeaderContextFilterMenu="False">
                <RowIndicatorColumn Visible="False">
                </RowIndicatorColumn>
                <ExpandCollapseColumn Created="True">
                </ExpandCollapseColumn>
                <Columns>
                    <%--<telerik:GridBoundColumn DataField="cis_osve" FilterControlAltText="Filter cis_osve column"
                        HeaderText="[%Č. osv.%]" UniqueName="cis_osve">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="text_osve" FilterControlAltText="Filter text_osve column"
                        HeaderText="[%Vzdělávací aktivita%]" UniqueName="text_osve">
                    </telerik:GridBoundColumn>--%>
                    <%--<telerik:GridBoundColumn DataField="typ_nazev" FilterControlAltText="Filter typ_nazev column"
                        HeaderText="[%Typ vzd. aktivity%]" UniqueName="dtyp_nazev">
                    </telerik:GridBoundColumn>--%>
                    <telerik:GridCheckBoxColumn DataField="je_akce" DataType="System.Boolean" FilterControlAltText="Filter je_akce column"
                        HeaderText="[%Akce%]" UniqueName="dje_akce">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridNumericColumn DataField="p_cislo" DataType="System.Int32" DecimalDigits="0"
                        FilterControlAltText="Filter p_cislo column" HeaderText="[%Č. akce%]" UniqueName="dp_cislo">
                    </telerik:GridNumericColumn>
                    <telerik:GridBoundColumn DataField="nazev_akce" FilterControlAltText="Filter nazev_akce column"
                        HeaderText="[%Školící akce%]" UniqueName="dnazev_akce">
                    </telerik:GridBoundColumn>
                    <%--<telerik:GridCheckBoxColumn DataField="je_pozadavek" DataType="System.Boolean" FilterControlAltText="Filter je_pozadavek column"
                        HeaderText="[%Požadováno%]" UniqueName="je_pozadavek">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridBoundColumn DataField="zdroj_text" FilterControlAltText="Filter zdroj_text column"
                        HeaderText="[%Zdroj požadavku%]" UniqueName="zdroj_text">
                    </telerik:GridBoundColumn>--%>
                    <telerik:GridNumericColumn DataField="dnu" DataType="System.Decimal" DecimalDigits="2"
                        FilterControlAltText="Filter dnu column" HeaderText="[%Dny%]" UniqueName="ddnu">
                    </telerik:GridNumericColumn>
                    <telerik:GridNumericColumn DataField="dnu_akreditovanych" DataType="System.Decimal" DecimalDigits="2"
                        FilterControlAltText="Filter dnu_akreditovanych column" HeaderText="[%Dny akreditované%]" UniqueName="ddnu_akreditovanych"
                        FilterControlWidth="50px">
                    </telerik:GridNumericColumn>
                    <telerik:GridNumericColumn DataField="hodin" DataType="System.Decimal" DecimalDigits="2"
                        FilterControlAltText="Filter hodin column" HeaderText="[%Hodiny%]" UniqueName="dhodin">
                    </telerik:GridNumericColumn>
                    <telerik:GridCheckBoxColumn DataField="platne" DataType="System.Boolean" FilterControlAltText="Filter platne column"
                        HeaderText="[%Platné%]" UniqueName="dplatne">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridDateTimeColumn DataField="platne_od" DataType="System.DateTime" FilterControlAltText="Filter platne_od column"
                        HeaderText="[%Platnost od%]" UniqueName="dplatne_od" DataFormatString="{0:d.M.yyyy}"
                        FilterDateFormat="d.M.yyyy">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="platne_do" DataType="System.DateTime" FilterControlAltText="Filter platne_do column"
                        HeaderText="[%Platnost do%]" UniqueName="dplatne_do" DataFormatString="{0:d.M.yyyy}"
                        FilterDateFormat="d.M.yyyy">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridBoundColumn DataField="akreditace" FilterControlAltText="Filter akreditace column"
                        HeaderText="[%Akreditace%]" UniqueName="dakreditace">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="typ_akreditace" FilterControlAltText="Filter typ_akreditace column"
                        HeaderText="[%Typ akreditace%]" UniqueName="dtyp_akreditace">
                    </telerik:GridBoundColumn>
                </Columns>
            </telerik:GridTableView>
        </DetailTables>
        <RowIndicatorColumn Visible="False">
        </RowIndicatorColumn>
        <ExpandCollapseColumn Created="True">
        </ExpandCollapseColumn>
        <Columns>
            <telerik:GridBoundColumn DataField="cis_osve" FilterControlAltText="Filter cis_osve column"
                HeaderText="[%Č. osv.%]" UniqueName="cis_osve" FilterControlWidth="50px">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="text_osve" FilterControlAltText="Filter text_osve column"
                HeaderText="[%Vzdělávací aktivita%]" UniqueName="text_osve">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="typ_nazev" FilterControlAltText="Filter typ_nazev column"
                HeaderText="[%Typ vzd. aktivity%]" UniqueName="typ_nazev">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="druh_nazev" FilterControlAltText="Filter druh_nazev column"
                HeaderText="[%Druh vzd. aktivity%]" UniqueName="druh_nazev">
            </telerik:GridBoundColumn>
            <telerik:GridCheckBoxColumn DataField="je_akce" DataType="System.Boolean" FilterControlAltText="Filter je_akce column"
                HeaderText="[%Akce%]" UniqueName="je_akce">
            </telerik:GridCheckBoxColumn>
            <telerik:GridNumericColumn DataField="p_cislo" DataType="System.Int32" DecimalDigits="0"
                FilterControlAltText="Filter p_cislo column" HeaderText="[%Č. akce%]" UniqueName="p_cislo"
                FilterControlWidth="50px">
            </telerik:GridNumericColumn>
            <telerik:GridBoundColumn DataField="nazev_akce" FilterControlAltText="Filter nazev_akce column"
                HeaderText="[%Školící akce%]" UniqueName="nazev_akce">
            </telerik:GridBoundColumn>
            <telerik:GridCheckBoxColumn DataField="je_pozadavek" DataType="System.Boolean" FilterControlAltText="Filter je_pozadavek column"
                HeaderText="[%Požadováno%]" UniqueName="je_pozadavek">
            </telerik:GridCheckBoxColumn>
            <telerik:GridBoundColumn DataField="zdroj_text" FilterControlAltText="Filter zdroj_text column"
                HeaderText="[%Zdroj požadavku%]" UniqueName="zdroj_text">
            </telerik:GridBoundColumn>
            <telerik:GridNumericColumn DataField="dnu" DataType="System.Decimal" DecimalDigits="2"
                FilterControlAltText="Filter dnu column" HeaderText="[%Dny%]" UniqueName="dnu"
                FilterControlWidth="50px">
            </telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="dnu_akreditovanych" DataType="System.Decimal" DecimalDigits="2"
                FilterControlAltText="Filter dnu_akreditovanych column" HeaderText="[%Dny akreditovane%]" UniqueName="dnu_akreditovanych"
                FilterControlWidth="50px">
            </telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="hodin" DataType="System.Decimal" DecimalDigits="2"
                FilterControlAltText="Filter hodin column" HeaderText="[%Hodiny%]" UniqueName="hodin"
                FilterControlWidth="50px">
            </telerik:GridNumericColumn>
            <telerik:GridCheckBoxColumn DataField="platne" DataType="System.Boolean" FilterControlAltText="Filter platne column"
                HeaderText="[%Platné%]" UniqueName="platne">
            </telerik:GridCheckBoxColumn>
            <telerik:GridDateTimeColumn DataField="platne_od" DataType="System.DateTime" FilterControlAltText="Filter platne_od column"
                HeaderText="[%Platnost od%]" UniqueName="platne_od" DataFormatString="{0:d.M.yyyy}"
                FilterDateFormat="d.M.yyyy" FilterControlWidth="100px">
            </telerik:GridDateTimeColumn>
            <telerik:GridDateTimeColumn DataField="platne_do" DataType="System.DateTime" FilterControlAltText="Filter platne_do column"
                HeaderText="[%Platnost do%]" UniqueName="platne_do" DataFormatString="{0:d.M.yyyy}"
                FilterDateFormat="d.M.yyyy" FilterControlWidth="100px">
            </telerik:GridDateTimeColumn>
            <telerik:GridCheckBoxColumn DataField="vyjimka" DataType="System.Boolean" FilterControlAltText="Filter vyjimka column"
                HeaderText="[%Výjimka%]" UniqueName="vyjimka">
            </telerik:GridCheckBoxColumn>
            <telerik:GridDateTimeColumn DataField="vyjimka_do" DataType="System.DateTime" FilterControlAltText="Filter vyjimka_do column"
                HeaderText="[%Výjimka do%]" UniqueName="vyjimka_do" DataFormatString="{0:d.M.yyyy}"
                FilterDateFormat="d.M.yyyy">
            </telerik:GridDateTimeColumn>
            <telerik:GridBoundColumn DataField="vyjimka_povolil" FilterControlAltText="Filter vyjimka_povolil column"
                HeaderText="[%Výjimku povolil%]" UniqueName="vyjimka_povolil">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="vyjimka_duvod" FilterControlAltText="Filter vyjimka_duvod column"
                HeaderText="[%Důvod výjimky%]" UniqueName="vyjimka_duvod">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="akreditace" FilterControlAltText="Filter akreditace column"
                HeaderText="[%Akreditace%]" UniqueName="akreditace">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="typ_akreditace" FilterControlAltText="Filter typ_akreditace column"
                HeaderText="[%Typ akreditace%]" UniqueName="typ_akreditace">
            </telerik:GridBoundColumn>
        </Columns>
        <PagerStyle PageSizes="10;20;50;100;200" AlwaysVisible="True" Mode="NextPrevAndNumeric" />
        <CommandItemTemplate>
            <table>
                <tr>
                    <td>
                        <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Načíst%]" CommandName="RebindGrid">
                            <Icon PrimaryIconCssClass="fi fi-rotate-right"></Icon>
                        </kspwc:TRadButton>
                    </td>
                    <td>
                        <kspwc:TRadButton ID="TRB_ch" runat="server" OnCheckedChanged="TRB_ch_CheckedChanged" Icon-PrimaryIconCssClass="fi fi-filter"
                            Text="[%Filtr%]" ToggleType="CheckBox">
                        </kspwc:TRadButton>
                    </td>
                    <td>
                        <cc1:ExportGridButton ID="ExportGridButton1" runat="server" RegistreWithAjaxManager="False"
                            ShowExportToPdfItem="False" ShowExportToExcelBIFFItem="false" ShowExportToExcelMLItem="false" ShowExportToExcelXlsxItem="false" ShowExportToWordDocxItem="false" ShowExportToWordItem="false" />
                    </td>
                </tr>
            </table>
        </CommandItemTemplate>
    </MasterTableView>
</cc1:TRadGrid>
<br />
<asp:ObjectDataSource ID="ODS_PozadovanaOsvedceni" runat="server" SelectMethod="PozadovanaOsvedceni"
    TypeName="KSProgram.Vzdelavani.KvalifikacniKarta"></asp:ObjectDataSource>
<%--<cc1:TGridView ID="TGridView4" runat="server" DataSourceID="ODS_PozadovanaOsvedceni"
    ShowTitleRow="True" TitleText="[%Požadované vzdělávací aktivity%]">
    <Columns>
        <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]" SortExpression="cislo" />
        <asp:BoundField DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" />
        <asp:BoundField DataField="zdroj" HeaderText="[%Zdroj požadavku%]" SortExpression="zdroj" />
        <asp:BoundField DataField="vyjimka_od" DataFormatString="{0:d}" HeaderText="[%Výjimka od%]"
            SortExpression="vyjimka_od"></asp:BoundField>
        <asp:BoundField DataField="vyjimka_do" DataFormatString="{0:d}" HeaderText="[%Výjimka do%]"
            SortExpression="vyjimka_do"></asp:BoundField>
        <asp:BoundField DataField="vyjimka_povolil" HeaderText="[%Výjimku povolil%]" SortExpression="vyjimka_povolil">
        </asp:BoundField>
    </Columns>
</cc1:TGridView>--%>
<asp:ObjectDataSource ID="ODS_ZiskanaOsvedceni" runat="server" SelectMethod="ZiskanaOsvedceni"
    TypeName="KSProgram.Vzdelavani.KvalifikacniKarta"></asp:ObjectDataSource>
<%--<cc1:TGridView ID="TGridView2" runat="server" DataSourceID="ODS_ZiskanaOsvedceni"
    ShowTitleRow="True" TitleText="[%Získané vzdělávací aktivity%]" SortAscImageUrl="" SortDescImageUrl=""
    OnRowDataBound="TGridView2_RowDataBound" ShowFooter="True">
    <Columns>
        <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]" SortExpression="cislo" />
        <asp:BoundField DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" />
        <asp:BoundField DataField="nazev_akce" HeaderText="[%Školící akce%]" SortExpression="nazev_akce" />
        <asp:BoundField DataField="dnu" HeaderText="[%Dnů%]" SortExpression="dnu" />
        <asp:BoundField DataField="typ" HeaderText="[%Typ%]" SortExpression="typ" />
        <asp:BoundField DataField="datum_od" HeaderText="[%Platí od%]" SortExpression="datum_od"
            DataFormatString="{0:d}" HtmlEncode="False" />
        <asp:BoundField DataField="datum_do" HeaderText="[%Platí do%]" SortExpression="datum_do"
            DataFormatString="{0:d}" HtmlEncode="False" />
        <asp:BoundField DataField="akreditace_cislo" HeaderText="[%Číslo akreditace%]" SortExpression="akreditace_cislo" />
    </Columns>
</cc1:TGridView>
--%>