﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="PrilohyManager.ascx.cs" Inherits="KSPortal.Controls.PrilohyManager" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .async-attachment .RadUpload .ruFakeInput {
        width: 300px !important;
    }


    .attachment-container {
        display: inline-block;
        background: rgba(58, 174, 251, .6);
        filter: progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr='#993aaefb', endColorstr='#993aaefb');
        width: calc(100% - 50px);
        height: calc(100% - 50px);
        padding: 25px;
    }

    .allowed-attachments {
        display: block;
        /*margin-top: 12px;*/
        /*font-size: 13px;*/
    }
    .RadUpload .ruBrowse
    {
        width:100px !important;
    }
    .RadUpload .ruBrowse
    {
        width:100px !important;
    }
</style>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="rb_send_soubor">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="pan_upload" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="rb_send_soubor">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RadGridPrilohy" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<kspwc:TRadGrid ID="RadGridPrilohy" runat="server" AutoGenerateColumns="false" OnNeedDataSource="RadGridPrilohy_NeedDataSource" OnDeleteCommand="RadGridPrilohy_DeleteCommand" CssClass="ksRgPrilohy">
    <MasterTableView runat="server" DataKeyNames="id,nazev_soubor" Caption="[%Přílohy%]" CommandItemDisplay="Top"  >
        <CommandItemSettings AddNewRecordText="[%Přidat nový záznam%]" />
        <Columns>
            <telerik:GridButtonColumn Text="Delete" CommandName="Delete" ButtonType="ImageButton" ConfirmDialogType="RadWindow" UniqueName="del_column" ColumnGroupName="pred"
                ConfirmTitle="Mazání" ConfirmText="[%Opravdu si přejete odstranit přílohu%]?" >
                <ItemStyle Width="20" />
                <HeaderStyle Width="20" />
            </telerik:GridButtonColumn>
            <telerik:GridTemplateColumn>
                <ItemStyle Width="20" HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" runat="server" Target="_blank" ToolTip='<%# "Stáhnout " + Eval("Nazev_soubor")  %>'
                        NavigateUrl='<%# genOpenDoklCode(Eval("Id_info_blob"), Eval("Nazev_soubor")) %>'>               
                <span class="rbDownload16 rbPredefinedIcons"></span>
                    </asp:HyperLink>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridBoundColumn DataField="nazev_soubor" HeaderText="[%Soubor%]"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="Nazev" HeaderText="[%Popis%]"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="Poridil" HeaderText="[%Uživatel%]"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="Datum_porizeni" HeaderText="[%Datum%]" DataFormatString="{0:d}">
                <ItemStyle Width="60" />
                <HeaderStyle Width="60" />
            </telerik:GridBoundColumn>
        </Columns>        
    </MasterTableView>
    <ClientSettings>
        <ClientEvents OnCommand="Pril_on_command" />
    </ClientSettings>
</kspwc:TRadGrid>
<%--<table>
   <tr>
        <td colspan="2">--%>
<telerik:RadWindow ID="PrilohaPopup" runat="server" OnClientBeforeShow="upload_reset" Title="[%Příloha%]" Modal="true" Behaviors="Close,Resize,Move" Width="610" Height="280" DestroyOnClose="false">
    <ContentTemplate>
        <asp:Panel runat="server" ID="pan_upload">

            <div style="padding: 15px; height: 150px;">
                <div id="DropZone" class="attachment-container">
                    <%--<asp:Label runat="server" ID="lab_vyber_soubor" Text="[%Vyberte soubory%]: "/><asp:Label runat="server" ID="lab_pripony" Font-Italic="true" Text="txt,doc,docx,ppt,xml,csv,xls,xlsx,ods,odt,pdf,html,mht,msg,bmp,jpg,png"></asp:Label>--%>
                    <div>
                        <telerik:RadAsyncUpload runat="server" Width="410" Localization-DropZone="drop" CssClass="async-attachment"
                            ID="RadAsyncUpload1" MaxFileInputsCount="1" AllowedFileExtensions="txt,doc,docx,ppt,xml,csv,xls,xlsx,ods,odt,pdf,htm,html,mht,msg,bmp,jpg,png"
                            HideFileInput="true" OnClientFileUploadRemoved="PrilohyRAU_OnClientFileUploadRemoved" OnClientValidationFailed="PrilohyRAU_OnClientValidationFailed" 
                            TemporaryFolder="~/Temp" OnClientFilesUploaded="PrilohyRAU_OnClientFilesUploaded"
                            PostbackTriggers="rb_send_soubor" DropZones="#DropZone" InputSize="22"
                            MaxFileSize='<%# KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") * 1048576 %>' >
                            <Localization Select="[%Vyberte soubor%]" Remove="[%Odstranit%]" Cancel="[%Zrušit%]" DropZone="[%Nyní můžete soubor pustit%]"></Localization>
                        </telerik:RadAsyncUpload>
                        <div style="height: 25px"></div>
                        <div id="pan_soubor">
                            <asp:Label runat="server" ID="lab_attachment" Text="[%Povolené typy souborů%]" CssClass="allowed-attachments"></asp:Label>
                            <span class="allowed-attachments-list">(<%= String.Join( ",", RadAsyncUpload1.AllowedFileExtensions ) %>)</span>
                        </div>


                        <%--<DIV id="#DropZone2" class="DropZone1">
                            <p>[%nebo sem přetáhněte soubor%]</p>                        
                        </DIV> --%>
                    </div>
                    <div id="div_nazev_souboru" style="display: none;">
                        <div>
                            <asp:Label runat="server" ID="lab_nazev" Text="[%Popis%]"></asp:Label>
                        </div>
                        <telerik:RadTextBox runat="server" ID="rtb_nazev_souboru" EmptyMessage="[%Popis%]" MaxLength="64" Text="" Width="400"></telerik:RadTextBox>
                    </div>
                </div>
            </div>

            <div style="background-color: ButtonFace; margin: 5px 0px 0px 0px; width: 100%;">
                <kspwc:TRadButton ID="rb_send_soubor" runat="server" AutoPostBack="true" OnClientClicked="rb_send_soubor_onClientClicked" CausesValidation="true" Style="margin: 4px;" Text="[%Uložit%]" Icon-PrimaryIconCssClass="fi fi-disk" ValidationGroup="prilohy_odeslani" />
            </div>

            <asp:ObjectDataSource ID="ds_typy_dokumentu" runat="server"></asp:ObjectDataSource>
        </asp:Panel>
    </ContentTemplate>
</telerik:RadWindow>
<telerik:RadScriptBlock ID="Pril_RSB" runat="server">
    <script type="text/javascript" id="PrilohyJS">
        //<![CDATA[   
        function PrilohyRAU_OnClientValidationFailed(sender, args) {
            var fileExtention = args.get_fileName().substring(args.get_fileName().lastIndexOf('.') + 1, args.get_fileName().length);
            if (args.get_fileName().lastIndexOf('.') != -1) {//this checks if the extension is correct
                if (sender.get_allowedFileExtensions().indexOf(fileExtention.toLowerCase()) == -1) {
                    radalert(<%= WebControlHelper.ZmenaTextu("'[%Nepovolená přípona souboru, povoleny jsou%]: '") %> + sender.get_allowedFileExtensions() + "!", 280, 145, <%= WebControlHelper.ZmenaTextu("'[%Chyba při vkládání%]'")  %>, null, null);
                }
                else {
                    radalert(<%= WebControlHelper.ZmenaTextu("'[%Příliš velký soubor, max. velikost je%] ") %> <%= KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") %> MB!', 280, 145,  <%= WebControlHelper.ZmenaTextu("'[%Chyba při vkládání%]'")  %>, null, null);
                }
            }
            else {
                radalert(<%= WebControlHelper.ZmenaTextu("'[%Nepovolená přípona souboru, povoleny jsou%]: '") %>  + sender.get_allowedFileExtensions() + "!", 280, 145,  <%= WebControlHelper.ZmenaTextu("'[%Chyba při vkládání%]'")  %>, null, null);
            }
        }
        function PrilohyRAU_OnClientFilesUploaded(sender, args) {
            switch_display('block', 'none');
            $find("<%= rtb_nazev_souboru.ClientID %>").focus();
        }
        function PrilohyRAU_OnClientFileUploadRemoved(sender, args) {
            switch_display('none', 'block');
        }
        function switch_display(display_mode, display_mode2) {
            $('#div_nazev_souboru').css('display', display_mode);
            $('#pan_soubor').css('display', display_mode2);
        }

        function rb_send_soubor_onClientClicked(sender, args) {
            var prilohaPopup = $find("<%= PrilohaPopup.ClientID %>");
            if (prilohaPopup) {
                prilohaPopup.close();
            }
            try {
                if (typeof Zadost_OnClientFileUploaded === "function") {
                    var upload = $find("<%= RadAsyncUpload1.ClientID %>");
                    var inputs = upload.getUploadedFiles();
                    if (inputs.length > 0) {
                        var file_uploaded = inputs[0];
                        Zadost_OnClientFileUploaded(file_uploaded);
                    }
                }
            }
            catch (err) {
                console.log(err.message);
                alert("chyba:" + err.message);
            }
        }
        function showPrilohu() {
            var prilohaPopup = $find("<%= PrilohaPopup.ClientID %>");
            if (prilohaPopup) {
                prilohaPopup.show();
            }
        }
        function upload_reset() {
            var upl = $find("<%= RadAsyncUpload1.ClientID %>");
            var count = upl._uploadedFiles.length;
            if (count > 0) {
                Array.removeAt(upl._uploadedFiles, 0);
                upl.deleteFileInputAt(0);
                upl.updateClientState();
            }
            switch_display('none', 'block');
            $find("<%= rtb_nazev_souboru.ClientID %>").clear();
        }
        function Pril_on_command(sender, args)
        {           
            if (args.get_commandName() === "InitInsert") {
                showPrilohu();
                args.set_cancel(true);
            }
        }

    //]]>
    </script>
</telerik:RadScriptBlock>
