﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostObudget"
    CodeBehind="ZadostObudget.ascx.cs" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .cisPol {
        text-align: right;
    }

    .cisPolSum {
        text-align: right;
        font-weight: bold;
    }

</style>

<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox"
    EnableRoundedCorners="false" DecorationZoneID="FormView1" />
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekbudget" InsertMethod="Insert"
    UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="id_budgetu" Type="Int32" />
        <asp:Parameter Name="id_protibudgetu" Type="Int32" />
        <asp:Parameter Name="castka" Type="Int32" />
        <asp:Parameter Name="druh_pohybu" Type="Int16" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="cislo_pom" Type="Int16" />
        <asp:Parameter Name="id_budgetu" Type="Int32" />
        <asp:Parameter Name="id_protibudgetu" Type="Int32" />
        <asp:Parameter Name="castka" Type="Int32" />
        <asp:Parameter Name="druh_pohybu" Type="Int16" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="rozpad" Type="Object" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource runat="server" ID="ds_pomery"
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetPomery"
    TypeName="KSProgram.Funkce.Prac_pom">
    <SelectParameters>
        <asp:Parameter Name="co" Type="String" DefaultValue="p" />
        <asp:Parameter DefaultValue="0" Name="os_cislo" Type="Decimal" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource runat="server" ID="dsDruhyPohybu" SelectMethod="getDruhyPohybu" TypeName="KSProgram.Pozadavky.Pozadavekbudget"></asp:ObjectDataSource>
<asp:ObjectDataSource runat="server" ID="dsBudgety" SelectMethod="getNazvyBudgetu" TypeName="KSProgram.Pozadavky.Pozadavekbudget"></asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted" OnLoad ="FormView1_Load"
    OnItemUpdated="FormView1_ItemUpdated" DataKeyNames="os_cislo">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" CssClass="RozpadTable">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na pohyb v budgetu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                                <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label18" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell19">
                    <asp:Label ID="Label19" runat="server" Text='<%# ((DateTime)Eval("obdobi")).ToString("yyyy MMMM")%>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID budgetu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <asp:Label ID="Label2" runat="server" Text='<%# Eval("id_budgetu")%>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow4">
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Částka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <asp:Label ID="Label15" runat="server" Text='<%# Eval("castka")%>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label16" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh pohybu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell14">
                    <asp:Label ID="Label17" runat="server" Text='<%# Eval("druh_pohybu")%>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID protibudgetu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                    <asp:Label ID="Label6" runat="server" Text='<%# Eval("id_protibudgetu")%>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text=''
                        Width="250px"></asp:Label>

                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

        </asp:Table>
    </ItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na převod z/do budgetu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server" Text=""></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label18" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Výběr období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell19">
                    <kspwc:TDropDown ID="DropDownMesic" runat="server" 
                        DataValueField="id" DropDownAutoWidth="Enabled" Width="50%" AutoPostBack="true">
                    </kspwc:TDropDown>
                    <kspwc:TDropDown ID="DropDownRok" runat="server" OnSelectedIndexChanged="naplnMesice"
                        DataValueField="id" DropDownAutoWidth="Enabled" Width="50%" AutoPostBack="true">
                    </kspwc:TDropDown>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                    <asp:DropDownList runat="server" ID="ddl_pomery" DataTextField="cislo_druh_nazev" AutoPostBack="true" DataValueField="cislo_pom" DataSourceID="ds_pomery" OnSelectedIndexChanged="ddl_pomery_SelectedIndexChanged"></asp:DropDownList>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID budgetu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <kspwc:TDropDown ID="DropDownBudgety" runat="server" DataTextField="popis" DataSourceID="dsBudgety"
                        DataValueField="id" DropDownAutoWidth="Enabled" ColumnSpan="1" Width="100%" AutoPostBack="true" OnSelectedIndexChanged="DropDownBudgety_SelectedIndexChanged">
                    </kspwc:TDropDown>
                    <kspwc:TRequiredValidator runat="server" ID="req_val_DropDownBudgety" ControlToValidate="DropDownBudgety" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell15" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell16">
                    <telerik:RadNumericTextBox ID="Zustatek" runat="server" Width="100%" Enabled="false"></telerik:RadNumericTextBox>
                </asp:TableCell>

            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label16" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh pohybu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell14">
                    <kspwc:TDropDown ID="Dropdown_druhy" runat="server" DataTextField="popis" DataSourceID="dsDruhyPohybu"
                        DataValueField="cislo" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="druhSelected"
                        ColumnSpan="1" Width="100%" AutoPostBack="true">
                    </kspwc:TDropDown>
                    <kspwc:TRequiredValidator runat="server" ID="req_val_druh_pohybu" ControlToValidate="Dropdown_druhy" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Částka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <telerik:RadNumericTextBox ID="TextBoxCastka" runat="server" DbValue='<%# Bind("castka") %>' Width="100%"></telerik:RadNumericTextBox>
                     <kspwc:TRequiredValidator runat="server" ID="req_val_TextBoxCastka" ControlToValidate="TextBoxCastka" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow3" VerticalAlign="Top">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID protibudgetu%]:" Visible="false"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell17">
                    <kspwc:TDropDown ID="DropDownProti" runat="server" DataTextField="popis" Visible="false" Width="312px"
                        DataValueField="id" DropDownAutoWidth="Enabled" ColumnSpan="1" AutoPostBack="true">
                    </kspwc:TDropDown>
                    <kspwc:TDropDown ID="DropDownZam" runat="server" DataTextField="jmeno" Visible="false" Width="312px"
                        DataValueField="id" DropDownAutoWidth="Enabled" ColumnSpan="1" AutoPostBack="true">
                    </kspwc:TDropDown>
                    <div style="width: fit-content; float:right;">
                    <kspwc:TRadButton AutoPostBack="true" runat="server" CausesValidation="false" ID="TRB_Recount" Text="[%Přepočítat%]" Icon-PrimaryIconCssClass="fi fi-calculator" OnClick="druhSelected" Width="160px" Visible="false" style="background: var(--kscolor2); color: var(--kscolor2text); border-radius: 5px;"/>
                    </div>
                    <div style="height: 70px"></div>
                    </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">

                    <telerik:RadTextBox ID="TextBoxDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="100"
                        TextMode="MultiLine" Width="100%" Height="40" Resize="Both" style="min-width: 283px">
                    </telerik:RadTextBox>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">

                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                  <kspwc:TRequiredValidator runat="server" ID="req_val_TextBoxDatVyrizeniInsert" ControlToValidate="TextBoxDatVyrizeniInsert" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </InsertItemTemplate>
    <FooterTemplate>
        <asp:CustomValidator ID="ValidateInput" runat="server" OnServerValidate="ValidateInput"
            ErrorMessage="Nesprávně zadaná data"></asp:CustomValidator>
    </FooterTemplate>

</asp:FormView>

