﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpreprava.ascx.cs" Inherits="KSPortal.Controls.ZadostOpreprava" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls" tagprefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadScriptBlock ID="Preprava_JS" runat="server">
    <script type="text/javascript" id="preprava_js">
        //<![CDATA[
        function AddRemoveCssClass(selector, cssclass, add) {
            if (add == true)
                $(selector).addClass(cssclass);
            else
                $(selector).removeClass(cssclass);
        }

        function RadioRidicClick() {
            var rb_ridic_int_id = '<%= FormView1.FindControl("rb_ridic_int") != null ? FormView1.FindControl("rb_ridic_int").ClientID : "" %>';
            var ridic_osc_id = '<%= FormView1.FindControl("ridic_osc") != null ? FormView1.FindControl("ridic_osc").ClientID : "" %>';
            var ridic_ext_id = '<%= FormView1.FindControl("ridic_ext") != null ? FormView1.FindControl("ridic_ext").ClientID : "" %>';
            var show_ridic_osc = document.getElementById(rb_ridic_int_id).checked;
            AddRemoveCssClass('#' + ridic_osc_id, "hidden", !show_ridic_osc);
            AddRemoveCssClass('#' + ridic_ext_id, "hidden", show_ridic_osc);
        }

        function initRidic() {
            var rb_ridic_int_id = '<%= FormView1.FindControl("rb_ridic_int") != null ? FormView1.FindControl("rb_ridic_int").ClientID : "" %>';
            var ridic_osc_id = '<%= FormView1.FindControl("ridic_osc") != null ? FormView1.FindControl("ridic_osc").ClientID : "" %>';
            var ridic_ext_id = '<%= FormView1.FindControl("ridic_ext") != null ? FormView1.FindControl("ridic_ext").ClientID : "" %>';
            var ridic_osc_DDL = $find(ridic_osc_id);
            var ridic_ext_TB = document.getElementById(ridic_ext_id);
            if (ridic_osc_DDL && ridic_ext_TB) {
                if (ridic_osc_DDL._selectedValue > "" || ridic_ext_TB.value > "") {
                    var show_ridic_osc = (ridic_osc_DDL._selectedValue > "");
                    document.getElementById(rb_ridic_int_id).checked = show_ridic_osc;
                    AddRemoveCssClass('#' + ridic_osc_id, "hidden", !show_ridic_osc);
                    AddRemoveCssClass('#' + ridic_ext_id, "hidden", show_ridic_osc);
                }
            }            
        }

        Sys.Application.add_load(initRidic);
            
        //]]>
    </script>
</telerik:RadScriptBlock>

<asp:ObjectDataSource ID="ODS_ridici" runat="server" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="FiremniRidici" 
    TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheDuration="60"> 
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_SluzVozy" runat="server" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="SelectSluzebni" 
    TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheDuration="60">
    <SelectParameters>
        <asp:Parameter Name="os_cislo" Type="Decimal" DefaultValue="0" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekpreprava" InsertMethod="Insert"
    UpdateMethod="Update" OnInserted="ObjectDataSource1_Inserted" >
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32"/>
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
    </SelectParameters>    
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1">
    <EditItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" >
                <asp:TableCell runat="server" ColumnSpan="4"  SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Žádost o přepravu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            
            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label2" runat="server" Text="[%Žadatel%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:Label ID="LabelZadatel" runat="server" Text=""></asp:Label> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spolu_L" runat="server" Text="[%Spolucestující%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="spolu" runat="server" Text='<%# Bind("spolu") %>' MaxLength="400" Width="35em" CssClass="input" ></kspwc:TTextBox> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="datum_od_L" runat="server" Text="[%Datum, čas a místo přistavení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <telerik:RadDateTimePicker runat="server" ID="datum_od" DbSelectedDate='<%# Bind("datum_od") %>' SkinID="povinne-pole" Width="14em" 
                        DateInput-DateFormat="dd.MM.yyyy HH:mm" DateInput-DisplayDateFormat="dd.MM.yyyy HH:mm">
                    </telerik:RadDateTimePicker>
                    &nbsp;
                    <asp:Label ID="pocatek_L" runat="server" Text="[%Místo přistavení%]:" Visible="false"></asp:Label>
                    <kspwc:TTextBox ID="pocatek"	runat="server" Text='<%# Bind("pocatek") %>' MaxLength="400"  Width="20em" CssClass="input povinne-pole" ToolTip="[%Místo přistavení%]"></kspwc:TTextBox>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="datum_do_L" runat="server" Text="[%Datum a čas ukončení jízdy%]:"></asp:Label> <br />
                    <asp:Label ID="Label5" runat="server" Text="[%(pesimistický odhad)%]"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <telerik:RadDateTimePicker runat="server" ID="datum_do" DbSelectedDate='<%# Bind("datum_do") %>' SkinID="povinne-pole" Width="14em" 
                        DateInput-DateFormat="dd.MM.yyyy HH:mm" DateInput-DisplayDateFormat="dd.MM.yyyy HH:mm" >

                    </telerik:RadDateTimePicker>
                    
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="odkud_kam_L" runat="server" Text="[%Odkud - kam%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="odkud_kam"	runat="server" Text='<%# Bind("odkud_kam") %>' MaxLength="400" Width="35em" CssClass="input povinne-pole"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">     
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kontakt_jmeno_L" runat="server" Text="[%Řidič se hlásí u%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="kontakt_jmeno"	runat="server" Text='<%# Bind("kontakt_jmeno") %>' MaxLength="100" Width="20em" CssClass="input povinne-pole"></kspwc:TTextBox> 
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kontakt_tel_L" runat="server" Text="[%Telefon%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="kontakt_tel"	runat="server" Text='<%# Bind("kontakt_tel") %>' MaxLength="20" Width="10em" CssClass="input povinne-pole"></kspwc:TTextBox> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="ucel_L" runat="server" Text="[%Účel jízdy%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="ucel"	runat="server" Text='<%# Bind("ucel") %>' MaxLength="400" Width="35em" CssClass="input povinne-pole"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="pzn_L" runat="server" Text="[%Poznámka%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="pzn"	runat="server" Text='<%# Bind("pzn") %>' MaxLength="400" Width="35em" CssClass="input"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" ID="tr_zatrzitka" Visible='<%# (this as KSProgram.Pozadavky.UserControlPozadavek).WF.FazeZprac == 1 %>' >                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:CheckBox runat="server" ID="cbx1" Text="[%požadavek schválen vedoucím%]" /> 
                    <br />
                    <asp:CheckBox runat="server" ID="cbx2" Text="[%požadavek předběžně projednán s vedoucím oddělení autoprovozu nebo garážmistrem%]" />
                </asp:TableCell>               
            </asp:TableRow>



            <asp:TableRow runat="server" Visible='<%# (this as KSProgram.Pozadavky.UserControlPozadavek).WF.FazeZprac > 2 %>' >                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="cislo_l" runat="server" Text="[%Číslo žádanky%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="cislo"	runat="server" Text='<%# Bind("cislo") %>' MaxLength="40" Width="10em" CssClass="input"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" Visible='<%# (this as KSProgram.Pozadavky.UserControlPozadavek).WF.FazeZprac > 2 %>' >                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="ridic_osc_L" runat="server" Text="[%Jméno řidiče%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:RadioButton runat="server" ID="rb_ridic_int" Text="[%interní%]" GroupName="ridic" onclick="RadioRidicClick()" Width="70px" />
                    <asp:RadioButton runat="server" ID="rb_ridic_ext" Text="[%externí%]" GroupName="ridic" onclick="RadioRidicClick()" Width="70px" />
                    <telerik:RadDropDownList ID="ridic_osc" runat="server"  Width="15em"  CssClass="povinne-pole hidden" SelectedValue='<%# Bind("ridic_osc") %>'
                        AutoPostBack="false" DataSourceID="ODS_ridici" DataValueField="os_cislo" DataTextField="cely_nazev">                        
                    </telerik:RadDropDownList>
                    <kspwc:TTextBox ID="ridic_ext"	runat="server" Text='<%# Bind("ridic_ext") %>' MaxLength="40" Width="20em" CssClass="input povinne-pole hidden"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" Visible='<%# (this as KSProgram.Pozadavky.UserControlPozadavek).WF.FazeZprac > 2 %>' >
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="druh_L" runat="server" Text="[%Druh vozidla%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="druh"	runat="server" Text='<%# Bind("druh") %>' MaxLength="40" Width="20em" CssClass="input"></kspwc:TTextBox> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" Visible='<%# (this as KSProgram.Pozadavky.UserControlPozadavek).WF.FazeZprac > 2 %>' >
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spz_L" runat="server" Text="[%RZ vozidla%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">                    
                    <%--SelectedValue='<%# Eval("spz") %>'
                        EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand="True" 
                        LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False" 
                        EmptyMessage="piš pro nabídku"--%>
                    <kspwc:TRadComboBox ID="spz" InputCssClass="povinne-pole" runat="server"  AllowCustomText="True" Width="300px" 
                        DataSourceID="ODS_SluzVozy" DataValueField="spz" DataTextField="spz_nazev" Text='<%# Bind("spz") %>' 
                        DropDownWidth="300px" MaxHeight="250px" >
                    </kspwc:TRadComboBox>
                </asp:TableCell>
            </asp:TableRow>
            
            <%--<asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <kspwc:TRadDatePicker runat="server" ID="vyridit_do" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="15em"/> </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </EditItemTemplate>
    <ItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" >
                <asp:TableCell runat="server" ColumnSpan="4"  SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Žádost o přepravu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label2" runat="server" Text="[%Žadatel%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:Label ID="LabelZadatel" runat="server" Text='<%#  KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno((decimal)Eval("os_cislo")) %>'></asp:Label> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spolu_L" runat="server" Text="[%Spolucestující%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("spolu") %>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="datum_od_L" runat="server" Text="[%Datum, čas a místo přistavení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("datum_od") %> &nbsp; <%# Eval("pocatek") %>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="datum_do_L" runat="server" Text="[%Datum a čas ukončení jízdy (pesimistický odhad)%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("datum_do") %>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="odkud_kam_L" runat="server" Text="[%Odkud - kam%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("odkud_kam") %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">     
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kontakt_jmeno_L" runat="server" Text="[%Řidič se hlásí u%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("kontakt_jmeno") %> 
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kontakt_tel_L" runat="server" Text="[%Telefon%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("kontakt_tel") %> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label3" runat="server" Text="[%Účel jízdy%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("ucel") %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="pzn_L" runat="server" Text="[%Poznámka%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("pzn") %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:CheckBox runat="server" ID="cbx1" Checked="true" Enabled="false" Text="[%požadavek schválen vedoucím%]" />
                    <br/>
                     <asp:CheckBox runat="server" ID="cbx2" Checked="true" Enabled="false"  Text="[%požadavek předběžně projednán s vedoucím oddělení autoprovozu nebo garážmistrem%]" />
                </asp:TableCell>               
            </asp:TableRow>


            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="cislo_l" runat="server" Text="[%Číslo žádanky%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("cislo") %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label4" runat="server" Text="[%Jméno řidiče%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# (Eval("ridic_osc") is decimal) ? (KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno((decimal)Eval("ridic_osc"))) : (Eval("ridic_ext")) %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="druh_L" runat="server" Text="[%Druh vozidla%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%# Eval("druh") %>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spz_L" runat="server" Text="[%RZ vozidla%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">                    
                    <%# Eval("spz") %>
                </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("vyridit_do") %> </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </ItemTemplate>
</asp:FormView>
<span class="tiskHide">
            <asp:CustomValidator runat="server" ID="Validator" OnServerValidate="Validator_ServerValidate" ></asp:CustomValidator>
        </span>