﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOprevdov.ascx.cs" Inherits="KSPortal.Controls.ZadostOprevdov" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .mess-container
    {
        padding:8px;
    }
</style>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekprevdov" InsertMethod="Insert"   
    OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted"
    UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating">    
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
         <asp:Parameter Name="os_cislo" Type="decimal"  />                 
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
    <UpdateParameters>
         <asp:Parameter Name="id_poz" Type="Int32" />       
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"  CssClass="nocss ksprvek"   
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound"  DataKeyNames="os_cislo">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="3" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek o převod dovolené do dalšího roku%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="2" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

           

             <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">  
                    <div class="mess-container">
                        <asp:Label runat="server" ID="label_text" Text='<%#  KSPortal.Controls.ZadostOprevdov.TextZadosti((Convert.ToDateTime(DataBinder.Eval(Container.DataItem, "obdobi")))) %>'></asp:Label>
                    </div>
                </asp:TableCell>
               
            </asp:TableRow>
            
            
              <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="2" ID="TCInsert8" SkinID="DataFieldStyle">                   
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>'
                        Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            </asp:Table>

            </ItemTemplate>

    <InsertItemTemplate>
         <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="2" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek o převod dovolené do dalšího roku%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
           

             <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                     <div class="mess-container">
                        <asp:Label runat="server" ID="label_text" ></asp:Label>
                     </div>
                </asp:TableCell>
               
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <telerik:RadTextBox ID="TextBoxDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990"
                        TextMode="MultiLine" Width="283px" Height="40"  Resize="Both"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="TextBoxDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
        <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
           </asp:Table>
    </InsertItemTemplate>
    <EditItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="3" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek o převod dovolené do dalšího roku%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="2" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                     <div class="mess-container">
                        <asp:Label runat="server" ID="label_text" ></asp:Label>
                     </div>
                </asp:TableCell>
               
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <telerik:RadTextBox ID="TextBoxDuvodEdit" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990"
                        TextMode="MultiLine" Width="283px" Height="40"  Resize="Both"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="TextBoxDuvodEdit"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
        <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
           </asp:Table>

    </EditItemTemplate>
    </asp:FormView>

