﻿<%@ Page MasterPageFile="~/Main.master" Language="C#" AutoEventWireup="true" Inherits="Dochazka_d3" Trace="false" CodeBehind="d3.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="cc4" %>
<%@ Register Assembly="zdroje" Namespace="KSProgram.WebControls" TagPrefix="cc2" %>
<%@ Register Assembly="zdroje" Namespace="KSProgram.Data" TagPrefix="cc1" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="aj" %>
<%@ Register Src="../Controls/RozdeleniPrescasu.ascx" TagName="RozdeleniPrescasu" TagPrefix="uc1" %>
<%@ Register TagPrefix="uc" TagName="poz_prilohy" Src="~/Controls/PrilohyManager.ascx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManager1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="ddlKod">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="pan_edit"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
        <script type="text/javascript">
            var popUp;
            var akt_obd_odprac=0;
            //var menuApp = new Object();
            var sendPar = new Object();
            sendPar.copyRadky = [];
            sendPar.pasteRadky = [];
            sendPar.obdobi = "";
            sendPar.akce = "";
            ctrlPressed = false;


            function PopUpShowing(sender, eventArgs) {                
                var popUp = eventArgs.get_popUp();
                var scrollTop = (typeof window.innerHeight != 'undefined' ? 0 : document.documentElement.scrollTop);
                var popUpWidth = popUp.style.width.substr(0, popUp.style.width.indexOf("px"));
                var popUpHeight = popUp.style.height.substr(0, popUp.style.height.indexOf("px"));
                var windowHeight = (typeof window.innerHeight != 'undefined' ? window.innerHeight : document.body.offsetHeight - scrollTop);
                var windowWidth = document.body.offsetWidth;
                //JH 30.6.2023 - HID 67600
                if (popUpHeight == "") popUpHeight = 600; // if the height isn't set on the popup, default to 600px 
                popUp.style.position = "fixed";

                popUp.style.height = popUpHeight + "px";
                popUp.style.left = (Math.floor((windowWidth - popUpWidth) / 2)).toString() + "px";
                popUp.style.top = (Math.floor((windowHeight - popUpHeight - 17) / 2) + scrollTop).toString() + "px";
                if (!$.support.leadingWhitespace) {
                    popUp.style.top = 200;
                    popUp.style.left = 150;
                }                
            }
      
            function CloseActiveToolTip() {
                var tooltip = Telerik.Web.UI.RadToolTip.getCurrent();
                if (tooltip) tooltip.hide();
            }
            function KeyPress(sender, eventArgs) {
                var kalendar = $find("<%=NabidkaObdobi.Picker.ClientID%>");
          var grid = $find("<%=SumaceMesic.ClientID%>");


          if (eventArgs.keyCode == 17) {
              ctrlPressed = true;
              return;
          }
          if (eventArgs.keyCode == 27) {
              sendPar.copyRadky = [];
              sendPar.pasteRadky = [];

              var masterTable = grid.get_masterTableView();
              var count = masterTable.get_dataItems().length;

              var item;
              for (var i = 0; i < count; i++) {
                  item = masterTable.get_dataItems()[i];
                  item.removeCssClass("rgRowBeforeCopy");
                  item.addCssClass("theme_alternaterow");
                  masterTable.deselectItem(masterTable.get_dataItems()[i].get_element());
              }
          } else if (eventArgs.keyCode == 67 && ctrlPressed) {
              var gridSelectedItems = grid.get_selectedItems();
              sendPar.copyRadky = [];
              sendPar.pasteRadky = [];

              for (var i = 0; i < gridSelectedItems.length; i++) {
                  sendPar.copyRadky.push(gridSelectedItems[i].get_itemIndex() + 1);
                  gridSelectedItems[i].addCssClass("rgRowBeforeCopy");
                  gridSelectedItems[i].removeCssClass("theme_selectedrow");
                  gridSelectedItems[i].removeCssClass("rgSelectedRow");
                  gridSelectedItems[i].removeCssClass("theme_alternaterow");

              }
          } else if (eventArgs.keyCode == 86 && ctrlPressed) {
              var gridSelectedItems = grid.get_selectedItems();
              sendPar.pasteRadky = [];
              for (var i = 0; i < gridSelectedItems.length; i++) {
                  sendPar.pasteRadky.push(gridSelectedItems[i].get_itemIndex() + 1);
              }
              var date = kalendar.get_selectedDate();
              sendPar.obdobi = (date.getMonth() + 1).toString() + "/" + date.getFullYear().toString();
              if ((sendPar.copyRadky.length > 0) && (sendPar.pasteRadky.length > 0)) {
                  sendPar.akce = "copy";
                  SendData();
              }
          } else if (eventArgs.keyCode == 46) {
              var gridSelectedItems = grid.get_selectedItems();
              if (gridSelectedItems.length > 0) {                 
                  radconfirm('Opravdu si přejete odstranit editovatelné záznamy ve vybraných dnech? ', confirmCallBackFn, 330, 150, null, 'Mazání záznamů');
              }
          }

          ctrlPressed = false;
      }

      function confirmCallBackFn(args) {
          if (args == true) {
              var kalendar = $find("<%=NabidkaObdobi.Picker.ClientID%>");
              var grid = $find("<%=SumaceMesic.ClientID%>");
              var gridSelectedItems = grid.get_selectedItems();
              sendPar.pasteRadky = [];
              for (var i = 0; i < gridSelectedItems.length; i++) {
                  sendPar.pasteRadky.push(gridSelectedItems[i].get_itemIndex() + 1);
              }
              var date = kalendar.get_selectedDate();
              sendPar.obdobi = (date.getMonth() + 1).toString() + "/" + date.getFullYear().toString();
              sendPar.akce = "del";
              if (sendPar.pasteRadky.length > 0) {
                  SendData();
              }
          }
      }

      function SendData() {
          var dt = JSON.stringify(sendPar);
          jQuery.ajax({
              type: 'POST',
              contentType: 'application/json; charset=utf-8',
              data: "{data:'" + dt + "'}",
              dataType: 'JSON',
              url: 'd3.aspx/SendData',
              success: function (result) {
                  __doPostBack('<%=SumaceMesic.ClientID %>', 'SumaceMesicBind');
                },
                error: function () {
                    alert('Chyba při odesílání dat');
                }
            });
                return false;
            }

            function RowContextMenu(sender, args) {
                args.get_tableView().selectItem($get(args.get_id()));
                var cm = $find("<%= RadMenu1.ClientID %>");
                if (cm != null)
                    cm.show(args.get_domEvent());
            $get("radGridClickedRowIndex").value = args.get_itemIndexHierarchical();
            }
            var wnd999;
             function OpenWndRozdel(id, args) {                 
                    var oManager = GetRadWindowManager();
                    oManager._width = 650;
                    oManager._height = 1500;

                    var pr = "";
                    var index = "";
                    if (id == "prescas") {
                        pr = "id=prescas";
                        index = "0";
                    }
                    else if (id == "svatek") {
                        pr = "id=svatek";
                        index = "1";
                    }
                    var kalendar = $find("<%=NabidkaObdobi.Picker.ClientID%>");
                    var date = kalendar.get_selectedDate();                 
                    pr += "&obdobi=" + (date.getMonth() + 1).toString() + "/" + date.getFullYear().toString();
                    wnd999 = oManager.open('../Dochazka/RozdeleniPrescasSvatek.aspx?' + pr, "RadWindow" + index);
                 //wnd999.set_modal(true);
                 debugger;
                 //wnd999.setSize(600, 1500);
                 wnd999._height = "1500px";
                    wnd999.add_close(closefunk);
                    return true;
             }
            function closefunk() {               
                obnovNVCerp();
            }
          
            function initCerp() {                
                var inter = setInterval(function () {
                    var pom = $find("<%=NabidkaObdobi.Picker.ClientID%>");
                    if (pom != null) {clearInterval(inter); obnovNVCerp(); };
                }, 30);
            }
            function obnovNVCerp() {               
                var kalendar = $find("<%=NabidkaObdobi.Picker.ClientID%>");
                
                if (kalendar != null) {
                    var date = kalendar.get_selectedDate();
                    var rok = date.getFullYear().toString();
                    var mes = (date.getMonth() + 1).toString();
                    PageMethods.nv_k_cerpani(rok, mes, onSucess, onError);
                }
                function onSucess(result) { 
                    var a = result.split("x");
                    var arr = a[0].split("|");
                    if (arr.length == 3) {
                        if (document.getElementById('<%=lab_svatek_celkem.ClientID %>') != null) {
                            document.getElementById('<%=lab_svatek_celkem.ClientID %>').innerHTML = arr[0];
                            document.getElementById('<%=lab_prace_sv_proplatit.ClientID %>').innerHTML = arr[1];
                            document.getElementById('<%=lab_nvs_zust.ClientID %>').innerHTML = arr[2];
                        }
                    }

                    var arr2 = a[1].split("|");
                    if (arr2.length == 3) {
                        if (document.getElementById('<%=lab_pr_celkem.ClientID %>') != null) {
                            document.getElementById('<%=lab_pr_celkem.ClientID %>').innerHTML = arr2[0];
                            document.getElementById('<%=lab_pr_proplac.ClientID %>').innerHTML = arr2[1];
                            document.getElementById('<%=lab_pr_zbyva.ClientID %>').innerHTML = arr2[2];
                        }
                    }                 
                    
                    
                    if (a[2] == "") {
                       <%-- $("#" + '<%=TableRow_dpp.ClientID %>').hide();    --%>                   
                    }
                    else {
                        var arr3 = a[2].split("|");
                        if (document.getElementById('<%=lab_odpracovano.ClientID %>') != null) {                           
                            document.getElementById('<%=lab_odpracovano.ClientID %>').innerHTML = arr3[0];
                            document.getElementById('<%=lab_limit.ClientID %>').innerHTML = arr3[1];
                            document.getElementById('<%=lab_limit_zbyva.ClientID %>').innerHTML = arr3[2];
                        }
                    }
                }
                function onError(result) {
                    //alert("Při zjišťování NVS došlo k chybě:"+result);                   
                }


            }
            function RadConfirmSPPKontrola(sender, args) {

                var cbfSPP = function (shouldSubmit) {
                    if (shouldSubmit) {
                        sender.click();
                        if (Telerik.Web.Browser.ff) {
                            sender.get_element().click();
                        }
                    }                   
                }
                if (dch_kontrola_spp) {                   
                    var combo = $find("<%=ddl_zmena_stavu.ClientID%>");
                    if (combo != null) {
                        if (combo.get_selectedItem().get_value() == "potvrzeny") {                            
                            var kalendar = $find("<%=NabidkaObdobi.Picker.ClientID%>");
                            if (kalendar != null) {
                                var date = kalendar.get_selectedDate();
                                var rok = date.getFullYear().toString();
                                var mes = (date.getMonth() + 1).toString();                               
                                args.set_cancel(true);
                                //PageMethods.kontrola_spp(rok, mes, onSucess, onError);
                                $.ajax({
                                    type: "POST",
                                    async: false,
                                    url: "d3.aspx/kontrola_spp",
                                    data: '{rok:'+rok+', mes:'+mes+'}',
                                    contentType: "application/json; charset=utf-8",
                                    dataType: "json",
                                    success: function (msg) {                                       
                                        if (msg.d != "") {                                           
                                            radconfirm("Zkontrolujte si a upravte hodnotu v poli SPP v měsíční sumaci a ve vyúčtování SC. SPP prvek ve vyúčtování SC se neshoduje s SPP prvkem v měsíční sumaci. Nezapomeňte zkontrolovat i počet hodin v záznamu na správnou hodnotu. " +

                                                msg.d + "<p> <b>OK</b> - ano jsem si vědom rozdílu a odesílám i přesto, že SPP prvky si neodpovídají. </p>" +
                                                "<p> <b>Cancel</b> - vracím se zpět k editaci měsíční sumace a/nebo SC, kterou ještě nemám korektně vyplněnou. </p>", cbfSPP, 500, 180, null, "Potvrzení");
                                        }
                                        else {
                                            args.set_cancel(false);
                                        }
                                    },                                
                                    error: function (xhr, ajaxOptions, thrownError) {
                                        alert(xhr.status);
                                        alert(xhr.responseText);
                                        alert(thrownError);
                                    }
                                });
                            }
                        }
                    }
                } 
            }
            function rttm_OnClientHide(sender, event) {               
                 __doPostBack('<%=SumaceMesic.ClientID %>', 'SumaceMesicBind');
            }
            
            function GridCreated(sender, args) {
                var scrollArea = sender.GridDataDiv;
                //var scrollTop = (typeof window.innerHeight != 'undefined' ? 0 : document.documentElement.scrollTop);                
                //var dataHeight = (typeof window.innerHeight != 'undefined' ? window.innerHeight : document.body.offsetHeight - scrollTop);

                //$get("body").height();
                //var dataHeight = sender.get_masterTableView().get_element().clientHeight;
                //    if (dataHeight < 600) {
                //    scrollArea.style.height = dataHeight - 400 + 17 + "px";
                //}
            }
            
           <%-- window.onresize = resizeGrid;
            function resizeGrid() {
                var grid= $get("<%= SumaceMesic.ClientID %>");
                GridCreated(grid, null);
            }--%>
        </script>

        <style type="text/css">
            .rgEditForm .rgHeader a {
                display: none !important;
            }

            .rgRowBeforeCopy {
                background-color: #FFFFCC !important;
            }

            .rbImageButton {
                background-repeat: no-repeat !important;
            }
            .rozd_data{
                min-width:40px;
                text-align:center;
            }
            .rgGroupHeader{
                background-color:darkgray!important;
                color:white!important;
            }
            .rgFooter td
            {
                background-color:darkgray!important;
                color:white!important;
                font-size:1.2em;
                font-weight:500;
                padding-right:0px !important;
                padding-bottom:10px !important;

            }
            .rgDataDiv
            {
                overflow-x: hidden !important;
            }
            .smena{
                color:blue;
                font-weight:bold;
            }
            .kstlacitko{
                text-decoration: none;
            }

            div.RadWindow.RadWindow_Metro.ksMessageAutoSize
            {
                height:600px !important;
            }

            div.RadWindow.RadWindow_Metro.ksMessageAutoSize div.rwContent.rwExternalContent{
                height: 100% !important;
            }
            
        </style>
    </telerik:RadCodeBlock>
    <telerik:RadToolTipManager runat="server" ID="RadToolTipManager1" Position="BottomLeft" Modal="false" ShowEvent="OnClick" HideEvent="ManualClose"
        RelativeTo="Element" Width="400px" Height="200px" Animation="Resize"
        OnAjaxUpdate="OnAjaxUpdate" RenderInPageRoot="true" OnClientHide="rttm_OnClientHide"
        AnimationDuration="200">
    </telerik:RadToolTipManager>
    <asp:Label ID="nadpis" CssClass="nadpis1" runat="server" Text="[%Měsíční sumace%]"></asp:Label>
    <table>
        <tr>
            <td colspan="2">
                <table width="100%">
                    <tr>
                        <td style="width: 250px;vertical-align:bottom">
                            <div>
                                <table style="border-collapse: collapse;">
                                    <tr>
                                        <td style="width: 120px;">
                                            <asp:Label runat="server" ID="lab_check" Text="[%Denní pořizování%]:" CssClass="pozadiText"></asp:Label>
                                        </td>
                                        <td>
                                            <kspwc:TCheckBox runat="server" ID="check_den" UseSaveSetting="true" AutoPostBack="true" OnCheckedChanged="check_den_CheckedChanged" />
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <table runat="server" id="tab_obdobi" style="border-collapse: collapse;">
                                <tr>
                                    <td style="width: 120px;">
                                        <asp:Label ID="Label100" runat="server" Text="[%Výběr období%]:" CssClass="pozadiText"></asp:Label>
                                    </td>
                                    <td>
                                        <%--<cc4:ObdobiText runat="server" ID="NabidkaObdobi" EnablePostBack="True" OnClick="NabidkaObdobi_Click">
                                        </cc4:ObdobiText>--%>
                                        <wc:TRadObdobi runat="server" ID="NabidkaObdobi" EnableTyping="False" OnSelectedDateChanged="NabidkaObdobi_Click">
                                            <Picker ID="Picker1" runat="server">
                                                <DateInput ReadOnly="true">
                                                </DateInput>
                                            </Picker>
                                        </wc:TRadObdobi>
                                    </td>
                                </tr>
                            </table>
                            <table runat="server" id="tab_den" style="border-collapse: collapse;">
                                <tr>
                                    <td style="width: 120px;">
                                        <asp:Label ID="Label5" runat="server" Text="[%Datum%]:" CssClass="pozadiText"></asp:Label>
                                    </td>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="VyberDatumu" AutoPostBack="true" OnSelectedDateChanged="vyberDatumu_SelectedDateChanged" ValidateRequestMode="Enabled">
                                        </kspwc:TRadDatePicker>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_VyberDatumu" ControlToValidate="VyberDatumu"></kspwc:TRequiredValidator>
                                    </td>
                                </tr>
                            </table>

                        </td>
                        <td style="padding-left: 10px; padding-right: 10px;">
                            <wc:TCheckBox ID="ch_rozbalit" runat="server" AutoPostBack="true" Text="[%Rozbalit vše%]"
                                OnCheckedChanged="ch_rozbalit_CheckedChanged" />
                        </td>
                       <%-- <td style="width: 150px">--%>
                         <td valign="bottom" style="padding-bottom: 10px;">                            
                             <div>
                                 <wc:TLinkButton ID="LinkButton2" SkinID="button" runat="server" OnCommand="img_1praclist_Command" Text="[%Pracovní list%]" CssClass="kstlacitko"></wc:TLinkButton>
                             </div>
                        </td>                      
                        <td align="right" valign="bottom">                            
                            <asp:Table runat="server" ID="table_prace_svatek" SkinID="RamAPozadi">
                             
                                <asp:TableRow runat="server" ID="TableRow_prace_ve_svatek">
                                    <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="TitleRowStyle">
                                        <asp:Label ID="Label8" runat="server" SkinID="TitleRowStyle" Text="[%Práce ve svátek%]"></asp:Label>
                                    </asp:TableCell>

                                    <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label7" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Celkem%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell6" CssClass="rozd_data">
                                        <asp:Label ID="lab_svatek_celkem" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>                                                   
                                    <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label6" runat="server" SkinID="DataFieldHeaderStyle" Text="[%K proplacení%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell3"  CssClass="rozd_data">
                                        <asp:Label ID="lab_prace_sv_proplatit" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>
                                     <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zbývá%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell2"  CssClass="rozd_data">
                                        <asp:Label ID="lab_nvs_zust" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell> 
                                    <asp:TableCell runat="server"  ID="TableCell4" SkinID="DataFieldStyle">
                                         <kspwc:TImageButton runat="server" ID="edit_col" IdPrava="295"  ImageUrl="~/Images/edit.png" ToolTip="[%Rozdělení práce ve svátek%]" OnClientClick="OpenWndRozdel('svatek', null);return false;" ></kspwc:TImageButton>
                                    </asp:TableCell>
                                </asp:TableRow>


                                <asp:TableRow runat="server" ID="TableRow_prace_prescas">
                                    <asp:TableCell runat="server" ID="TableCell8" HorizontalAlign="Right" SkinID="TitleRowStyle">
                                        <asp:Label ID="Label9" runat="server" SkinID="TitleRowStyle" Text="[%Práce přesčas%]"></asp:Label>
                                    </asp:TableCell>

                                    <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label10" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Celkem%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell10"  CssClass="rozd_data">
                                        <asp:Label ID="lab_pr_celkem" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>                                                   
                                    <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%K proplacení%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell12"  CssClass="rozd_data">
                                        <asp:Label ID="lab_pr_proplac" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>
                                     <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zbývá%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell14"  CssClass="rozd_data">
                                        <asp:Label ID="lab_pr_zbyva" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell> 
                                    <asp:TableCell runat="server"  ID="TableCell15" SkinID="DataFieldStyle">
                                         <kspwc:TImageButton runat="server" ID="TImageButton1" IdPrava="27"  ImageUrl="~/Images/edit.png" ToolTip="[%Rozdělení práce přesčas%]" OnClientClick="OpenWndRozdel('prescas', null);return false;" ></kspwc:TImageButton>
                                    </asp:TableCell>
                                </asp:TableRow>


                                 <asp:TableRow runat="server" ID="TableRow_dpp">
                                    <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="Right" SkinID="TitleRowStyle">
                                        <asp:Label ID="Label11" runat="server" SkinID="TitleRowStyle" Text="[%DPP-čerpání limitu%]"></asp:Label>
                                    </asp:TableCell>
                                      <asp:TableCell runat="server" ID="TableCell19" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label16" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Limit%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell20"  CssClass="rozd_data">
                                        <asp:Label ID="lab_limit" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TableCell17" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Čerpáno%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell18"  CssClass="rozd_data">
                                        <asp:Label ID="lab_odpracovano" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell>                                                   
                                   
                                     <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                                        <asp:Label ID="Label18" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zbývá%]:"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell22"  CssClass="rozd_data">
                                        <asp:Label ID="lab_limit_zbyva" runat="server" Text="00:00"></asp:Label>
                                    </asp:TableCell> 
                                    <asp:TableCell runat="server"  ID="TableCell23" SkinID="DataFieldStyle">                                        
                                    </asp:TableCell>
                                </asp:TableRow>

                                </asp:Table>
                            
                             <%--<wc:TLinkButton ID="TLinkButton1" SkinID="button" runat="server"  OnClientClick="OpenWndRozdel('svatek', null);return false;"  IdPrava="27" Width="80%" Text="[%Rozdělení práce ve svátek%]"></wc:TLinkButton>--%>
                        </td>
                        <td align="right" style="margin-left: 100px"></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td align="left" valign="top"></td>
            <td align="left" valign="top" style="width:800px">
                <wc:TRadGrid ID="SumaceMesic" runat="server" OnItemDataBound="SumaceMesic_ItemDataBound" ShowFooter="True" OnItemCommand="SumaceMesic_ItemCommand"
                    OnItemCreated="SumaceMesic_ItemCreated" OnPreRender="SumaceMesic_PreRender" PageSize="16" AccessKey="c" IdPravaEditace="17" ShowFooterWhenEmpty="False" AllowMultiRowSelection="true" SelectedItemStyle-CssClass="theme_selectedrow">
                    <ClientSettings AllowKeyboardNavigation="false">
                        <Scrolling UseStaticHeaders="true" AllowScroll="true" SaveScrollPosition="true" ScrollHeight="500" />
                        <Selecting AllowRowSelect="true" />
                        <ClientEvents OnRowContextMenu="RowContextMenu" OnGridCreated="GridCreated" />
                        <%--<ClientEvents OnKeyPress="KeyPress"  />   --%>
                    </ClientSettings>
                    <MasterTableView ShowGroupFooter="true" ClientDataKeyNames="den" DataKeyNames="den" AutoGenerateColumns="false" AllowAutomaticInserts="true" Caption="[%Dny měsíce%]" Width='<%# _sirka() %>'>
                        <GroupByExpressions>
                            <telerik:GridGroupByExpression>
                                <%-- <SelectFields>
                            <telerik:GridGroupByField FieldAlias="Received" FieldName="Received" FormatString="{0:D}"
                                HeaderValueSeparator=" from date: "></telerik:GridGroupByField>
                        </SelectFields>--%>
                                <GroupByFields>
                                    <telerik:GridGroupByField FieldName="vo_index" SortOrder="Ascending"></telerik:GridGroupByField>
                                </GroupByFields>
                            </telerik:GridGroupByExpression>
                        </GroupByExpressions>

                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <Columns>
                            <telerik:GridTemplateColumn HeaderText="" DataField="den" UniqueName="id_den">
                                <ItemTemplate>
                                    <asp:Label ID="Label1" runat="server" Text='<%# Convert.ToDateTime(DataBinder.Eval(Container.DataItem, "den")).Day+". "+DataBinder.Eval(Container.DataItem, "naz_dne") %>'></asp:Label>
                                </ItemTemplate>                           
                            </telerik:GridTemplateColumn>
                                 <%--
                            <telerik:GridBoundColumn DataField="fond" HeaderText="[%Fond%]" ReadOnly="True" UniqueName="id_fond">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            --%>
                             <telerik:GridTemplateColumn HeaderText="[%Fond%]" DataField="fond" UniqueName="id_fond">
                                <ItemTemplate>
                                    <asp:Label ID="LabelFond" runat="server" Text=""></asp:Label>
                                    <asp:Label ID="LabelSmena" runat="server" Text="" CssClass="smena"></asp:Label>
                                </ItemTemplate>                           
                            </telerik:GridTemplateColumn>

                            <telerik:GridBoundColumn DataField="odprac" HeaderText="[%Odprac.%]" ReadOnly="True" UniqueName="id_odprac">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <%--<telerik:GridBoundColumn DataField="ranni" HeaderText="-[%ranní%]" ReadOnly="True" Visible="False">
                            <ItemStyle HorizontalAlign="Right" />
                            <FooterStyle HorizontalAlign="Right" />
                        </telerik:GridBoundColumn>--%>
                            <telerik:GridBoundColumn DataField="odpoledni" HeaderText="-[%odpol.%]" ReadOnly="True" UniqueName="id_odpoledni">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="nocni" HeaderText="-[%noční%]" ReadOnly="True" UniqueName="id_nocni">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="absence" HeaderText="[%Absence%]" ReadOnly="True" UniqueName="id_absence">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="rozdil" HeaderText="[%Rozdíl%]" ReadOnly="True" UniqueName="id_rozdil">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="pohotovost" HeaderText="[%Pohotovost%]" UniqueName="id_pohotovost">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="castka" HeaderText="[%Částka%]" UniqueName="id_castka">
                                <ItemStyle HorizontalAlign="Right" />
                                <FooterStyle HorizontalAlign="Right" />
                            </telerik:GridBoundColumn>
                            <telerik:GridTemplateColumn>
                                <EditItemTemplate>
                                    <asp:TextBox ID="TextBox_chyba" runat="server" Text='<%# Bind("chyba") %>'></asp:TextBox>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    <div style="width: 15px; padding: 0px;">
                                        <asp:Image ID="Image7" runat="server" ImageUrl="~/Images/Error.png" ToolTip='<%# Convert.ToString(DataBinder.Eval(Container.DataItem, "chyba")) %>' Visible='<%# (Convert.ToString(DataBinder.Eval(Container.DataItem, "chyba")).Length>0?true:false) %>' />
                                        <asp:Image ID="Image1" runat="server" ImageUrl="~/Images/Warning.png" ToolTip='<%# Convert.ToString(DataBinder.Eval(Container.DataItem, "varovani")) %>' Visible='<%# (Convert.ToString(DataBinder.Eval(Container.DataItem, "varovani")).Length>0?true:false) %>' />
                                    </div>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <%-- <telerik:GridButtonColumn CommandName="Insert" Text="Vložit" ButtonType="ImageButton"  UniqueName="vlozit" >                        
                        </telerik:GridButtonColumn>--%>
                            <telerik:GridTemplateColumn>
                                <EditItemTemplate>
                                    <asp:Label ID="Lab4" runat="server" Text='<%# Eval("den") %>'></asp:Label>
                                </EditItemTemplate>
                                <ItemStyle HorizontalAlign="Right" />
                                <ItemTemplate>
                                    <asp:ImageButton runat="server" ID="img_expand"
                                        ImageUrl="~/images/menu_expand.png" CommandName="prepni"
                                        OnCommand="img_expand_oncommand"
                                        Visible="<%# Convert.ToBoolean(KSProgram.Dochazka.ParametryDochazky.HIDE_SIPKY) %>" />
                                    <%--<asp:ImageButton ID="img_vlozit" runat="server" ToolTip="[%Vložit nový%]" ImageUrl="~/Images/DataContainer_NewRecordHS.png" CommandName="insert" OnCommand="img_vlozit_Command" />--%>
                                    <kspwc:TRadButton ID="img_vlozit" runat="server" ToolTip="[%Vložit%]" Icon-PrimaryIconCssClass="fi fi-add" OnCommand="img_vlozit_Command" CommandName="insert">
                                    </kspwc:TRadButton>

                                    <telerik:RadButton  ID="btnPrest" runat="server" ButtonType="ToggleButton" ToggleType="CustomToggle" Width="20" Height="20" OnClick="btnPrest_OnClick" Checked="false">
                                        <ToggleStates>
                                            <telerik:RadButtonToggleState ImageUrl="../ImagesN/bez_prestavky.png" HoveredImageUrl="../ImagesN/bez_prestavky.png" Value="true"></telerik:RadButtonToggleState>
                                            <telerik:RadButtonToggleState ImageUrl="../imagesN/s_prestavkou.png" HoveredImageUrl="../imagesN/s_prestavkou.png" Value="false"></telerik:RadButtonToggleState>
                                        </ToggleStates>
                                    </telerik:RadButton>

                                    <tr>
                                        <td colspan="100%" align="right" style="padding-bottom: 0px; padding-top: 0px;">
                                            <div runat="server" id="div_grid" style="padding: 0px; white-space: nowrap;">
                                                <wc:TRadGrid ID="TGridViewDen" runat="server"
                                                    ShowHeader="False" GridLines="None" Width="100%" DataSourceID="dsDen"
                                                    OnItemCommand="TGridViewDen_ItemCommand" OnItemCreated="TGridViewDen_ItemCreated"
                                                    OnPreRender="TGridViewDen_PreRender" CaptionVisible="false"
                                                    OnItemDataBound="TGridViewDen_ItemDataBound" OnDataBinding="TGridViewDen_DataBinding" SkinID="GridLineHorizontal">
                                                    <%-- <EmptyDataRowStyle BackColor="White" />--%>
                                                    <MasterTableView DataKeyNames="id,den" DataSourceID="dsDen" AutoGenerateColumns="false" AllowAutomaticDeletes="true" EditMode="PopUp">
                                                        <EditFormSettings>
                                                            <%--<EditColumn ButtonType="ImageButton" />--%>
                                                            <PopUpSettings Modal="true" ShowCaptionInEditForm="true" CloseButtonToolTip="Zavřít" />
                                                        </EditFormSettings>
                                                        <Columns>
                                                            <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Left" HeaderText="[%Kód%]">
                                                                <ItemTemplate>
                                                                    <table style="border-collapse: collapse;">
                                                                        <tr>
                                                                            <td style="padding-right: 5px;">
                                                                                <span runat="server" id="span_help" class="rbHelp16 rbPredefinedIcons" style="vertical-align: middle;"></span>
                                                                            </td>
                                                                            <td>
                                                                                <div style="white-space: nowrap; vertical-align: middle;">
                                                                                    <asp:Label ID="Lab_kod" runat="server" Text='<%# VyplnKod(Container.DataItem,"kod") %>'></asp:Label>
                                                                                    <div style="width: 60px; height: 1px;"></div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </table>

                                                                </ItemTemplate>
                                                                <HeaderTemplate>

                                                                    <asp:Label runat="server" ID="lab_header_kod" Text="[%Kód%]"></asp:Label>
                                                                </HeaderTemplate>
                                                                <FooterTemplate>
                                                                    <asp:DropDownList ID="f_ddlKod" runat="server" DataSourceID="dsDdlKody" DataTextField="volitelne" DataValueField="kod" AutoPostBack="true" OnSelectedIndexChanged="f_ddlKod_SelectedIndexChanged">
                                                                    </asp:DropDownList>
                                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="f_ddlKod" ValidationGroup="editf" ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                                                </FooterTemplate>
                                                                <ItemStyle />
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn ItemStyle-Width="110" HeaderText="[%Čas od%]">
                                                                <ItemTemplate>
                                                                    <asp:Label ID="Lab_od"  runat="server" Text='<%# VyplnCas(Container.DataItem,"cas_od") %>'></asp:Label>
                                                                </ItemTemplate>
                                                                <ItemStyle Width="110px" />
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn ItemStyle-Width="110" HeaderText="[%Čas do%]">
                                                                <ItemTemplate>
                                                                    <asp:Label ID="Lab_do" runat="server" Text='<%# VyplnCas(Container.DataItem,"cas_do") %>'></asp:Label>
                                                                </ItemTemplate>
                                                                <ItemStyle Width="110px" />
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn ItemStyle-Width="110" HeaderText="[%Doba%]">
                                                                <ItemTemplate>
                                                                    <div style="white-space: nowrap;">
                                                                        <asp:Label runat="server" ID="lab_doba" Text="[%Doba%]:"></asp:Label>
                                                                        <asp:Label runat="server" ID="item_doba" Text='<%# KSProgram.Funkce.Cas_na_min.GetCasString(DataBinder.Eval(Container.DataItem, "doba")) %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                                <ItemStyle Width="110px" />
                                                            </telerik:GridTemplateColumn>

                                                            <telerik:GridTemplateColumn HeaderText="[%Středisko%]" UniqueName="id_prac_str">
                                                                <ItemTemplate>
                                                                    <asp:Panel ID="pan_item_stred" runat="server" Style="padding-right: 10px; padding-left: 10px;">
                                                                        <asp:Label ID="Label102" runat="server" Text='<%# KSProgram.Ciselniky.CisOjDochazka.PopisekOJ(true) %>'></asp:Label>
                                                                        <asp:Label ID="Label101" runat="server" Text='<%# Bind("prac_str") %>'></asp:Label>
                                                                    </asp:Panel>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn FooterStyle-Wrap="false" HeaderText="Dávka" UniqueName="id_c_pole1">
                                                                <ItemTemplate>
                                                                    <div style="padding-right: 10px">
                                                                        <asp:Label ID="Label2" runat="server" Text='<%# Bind("c_pole1") %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn FooterStyle-Wrap="false" HeaderText="[%Sazba%]" UniqueName="id_sazba">
                                                                <ItemTemplate>
                                                                    <div style="padding-right: 10px">
                                                                        <asp:Label ID="Label3" runat="server" Text='<%# Bind("sazba") %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn FooterStyle-Wrap="false" HeaderText="[%Částka%]" UniqueName="id_castka">
                                                                <ItemTemplate>
                                                                    <div style="padding-right: 10px">
                                                                        <asp:Label ID="Label4" runat="server" Text='<%# Bind("castka") %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>

                                                            <telerik:GridTemplateColumn FooterStyle-Wrap="false" HeaderText="[%Projekt/Úloha%]" UniqueName="id_proj_uloha">
                                                                <ItemTemplate>
                                                                    <div style="padding-right: 10px">
                                                                        <asp:Label ID="lab_c_pole12" runat="server" Text='<%# Eval("c_pole1")+"/"+Eval("c_pole2") %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>
                                                            <telerik:GridTemplateColumn FooterStyle-Wrap="false" HeaderText="[%Projekt%]" UniqueName="id_proj">
                                                                <ItemTemplate>
                                                                    <div style="padding-right: 10px">
                                                                        <asp:Label ID="lab_c_pole2" runat="server" Text='<%# Eval("c_pole1") %>'></asp:Label>
                                                                    </div>
                                                                </ItemTemplate>
                                                            </telerik:GridTemplateColumn>

                                                            <telerik:GridEditCommandColumn ButtonType="ImageButton" EditText="[%Edit%]" UniqueName="EditColumn">
                                                                <ItemStyle Width="20" />
                                                            </telerik:GridEditCommandColumn>
                                                            <telerik:GridButtonColumn CommandName="Delete" ButtonType="ImageButton" Text="[%Smazat%]" UniqueName="DeleteColumn" />
                                                        </Columns>
                                                        <EditFormSettings UserControlName="d3_editace.ascx" EditFormType="WebUserControl">
                                                            <EditColumn UniqueName="EditColumn">
                                                            </EditColumn>
                                                            <PopUpSettings Width="500" />
                                                        </EditFormSettings>
                                                    </MasterTableView>
                                                    <ClientSettings>
                                                        <ClientEvents OnPopUpShowing="PopUpShowing" />
                                                        <%-- <Selecting AllowRowSelect="true" />--%>
                                                    </ClientSettings>
                                                    <ValidationSettings CommandsToValidate="PerformInsert,Update"></ValidationSettings>
                                                </wc:TRadGrid>
                                                <asp:ObjectDataSource ID="dsDen" runat="server" TypeName="KSProgram.Dochazka.PorizeniDen" SelectMethod="NacistDen" UpdateMethod="UpdateDen" DeleteMethod="DeleteZaznam" OnDeleted="dsDen_Deleted" OnUpdated="dsDen_Updated"
                                                    OnUpdating="dsDen_Updating">
                                                    <SelectParameters>
                                                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                        <asp:Parameter Name="den" DbType="DateTime" />
                                                    </SelectParameters>
                                                    <UpdateParameters>
                                                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                        <asp:Parameter Name="den" DbType="DateTime" />
                                                        <asp:Parameter Name="kod" DbType="Int32" />
                                                        <asp:Parameter Name="hod_od" DbType="Int32" />
                                                        <asp:Parameter Name="min_od" DbType="Int32" />
                                                        <asp:Parameter Name="hod_do" DbType="Int32" />
                                                        <asp:Parameter Name="min_do" DbType="Int32" />
                                                        <asp:Parameter Name="hod_doba" Type="Int32" />
                                                        <asp:Parameter Name="min_doba" Type="Int32" />
                                                        <asp:Parameter Name="id" DbType="String" />
                                                        <asp:Parameter Name="original_id" DbType="String" />

                                                        <asp:Parameter Name="c_pole1" DbType="String" />
                                                        <asp:Parameter Name="sazba" DbType="Decimal" />
                                                        <asp:Parameter Name="castka" DbType="Decimal" />
                                                        <asp:Parameter Name="poznamka" DbType="String" />
                                                    </UpdateParameters>
                                                    <DeleteParameters>
                                                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                        <asp:Parameter Name="den" DbType="DateTime" />
                                                        <asp:Parameter Name="id" DbType="String" />
                                                        <asp:Parameter Name="original_id" DbType="String" />
                                                    </DeleteParameters>
                                                </asp:ObjectDataSource>
                                            </div>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </wc:TRadGrid>                
                 <div style="width:100%;margin-top:10px;">
                  <uc:poz_prilohy ID="uc_prilohy" runat="server" Vlastnik="workfl_hl" style="width:100%" /> 
                 </div>
                       
                <%--OnUpdated="dsMesic_Updated"--%>
                <asp:ObjectDataSource ID="dsMesic" runat="server" SelectMethod="CelyMesic" TypeName="KSProgram.Dochazka.Dochazka" UpdateMethod="DbUpdateCelyMesic" DeleteMethod="DbDeleteCelyMesic"
                    OldValuesParameterFormatString="original_{0}">
                    <SelectParameters>
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                        <asp:Parameter Name="dat_od" Type="DateTime" />
                        <asp:Parameter Name="dat_do" Type="DateTime" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:ObjectDataSource ID="dsStred" runat="server" SelectMethod="VsechnaStrediska"
                    TypeName="KSProgram.Ciselniky.CisStredisko"
                    OldValuesParameterFormatString="original_{0}" CacheDuration="60" EnableCaching="true"
                    CacheKeyDependency='<%# KSProgram.Globals.User %>' CacheExpirationPolicy="Absolute">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="NabidkaObdobi" Name="datumOd" PropertyName="SelectedDate"
                            Type="DateTime" DefaultValue="" />
                        <asp:ControlParameter ControlID="NabidkaObdobi" Name="datumDo" PropertyName="SelectedDate"
                            Type="DateTime" />
                        <asp:Parameter Name="ab_prazdny" DefaultValue="true" Type="Boolean" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:ObjectDataSource runat="server" ID="dsDdlKody" TypeName="KSProgram.Ciselniky.CisDchKody"
                    SelectMethod="KodZkratkaNazev" EnableCaching="true" CacheKeyDependency='<%# KSProgram.Globals.User %>'
                    CacheDuration="30" CacheExpirationPolicy="Absolute">
                    <SelectParameters>
                        <asp:Parameter Name="sender" DbType="String" DefaultValue="D" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <br />
                <table runat="server" id="pan_schval_gen" style="border-collapse: collapse;">
                    <tr>
                        <td valign="top">
                            <asp:Panel runat="server" ID="PanelZmenaStavu">
                                <table style="border-collapse: collapse">
                                   <%-- <tr>                                    
                                    <td colspan="2">
                                        <asp:Label runat="server" ID="lbl_problem" EnableViewState="False"
                                            ForeColor="Red"></asp:Label>
                                    </td>
                              
                                    </tr>--%>
                                    <tr>
                                        <td>
                                            <asp:ObjectDataSource ID="dsStavyEdit" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="StavyPozadavkuProTyp" TypeName="KSProgram.Pozadavky.WorkflowProces">
                                                <SelectParameters>
                                                    <asp:Parameter Name="id_poz" Type="Int32" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <%--<asp:DropDownList runat="server" ID="ddl_zmena_stavu"
                                                DataTextField="popis"
                                                DataValueField="hodnota" OnSelectedIndexChanged="ddl_zmena_stavu_SelectedIndexChanged">
                                            </asp:DropDownList>--%>
                                            <telerik:RadComboBox runat="server" ID="ddl_zmena_stavu" DataTextField="popis"
                                                DataValueField="hodnota">
                                            </telerik:RadComboBox>
                                        </td>
                                        <td style="padding-left: 5px">
                                            <%--<wc:TLinkButton runat="server" ID="lb_zmena_stavu" Text="[%Změna stavu%]"
                                                SkinID="button" OnCommand="lb_zmena_stavu_Command" OnClientClick="confirmLinkButton(this); return false;"></wc:TLinkButton>--%>
                                            <wc:TRadButton runat="server" ID="lb_zmena_stavu" Text="[%Změna stavu%]" CssClass="kstlacitko"
                                                OnCommand="lb_zmena_stavu_Command" OnClientClicking="RadConfirmSPPKontrola"></wc:TRadButton>
                                            <%--OnClientClicked="confirmLinkButton(this); return false;"--%>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                        <td valign="top" style="padding-left: 5px">
                            <table style="border-collapse:collapse;">
                                <tr>
                                    <td colspan="2">
                                        <%--<wc:TLinkButton runat="server" ID="lb_generovat" Text="[%Generovat podle kalendáře%]" SkinID="button" OnCommand="lb_generovat_Command"></wc:TLinkButton>--%>
                                        <wc:TRadButton  runat="server" ID="lb_generovat" Text="[%Generovat podle kalendáře%]" SkinID="button" OnCommand="lb_generovat_Command" CssClass="kstlacitko"></wc:TRadButton>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="lbl_problem" EnableViewState="False"
                                            ForeColor="Red"></asp:Label>
                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>
                   <%-- <tr>
                        <td>
                            <uc:poz_prilohy ID="uc_prilohy" runat="server" Vlastnik="workfl_hl" style="width:100%" />                           
                        </td>
                    </tr>--%>
                </table>
            </td>
        </tr>
    </table>
    <telerik:RadContextMenu ID="RadMenu1" runat="server" OnItemClick="RadMenu1_ItemClick"
        EnableRoundedCorners="true" EnableShadows="true">
        <Items>
            <telerik:RadMenuItem Text="[%Srovnat podle fondu%]" Value="srovnat_fond">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem Text="[%Potlačit generování přestávky%]" Value="potlacit_prestavku">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem Text="[%Povolit generování přestávky%]" Value="povolit_prestavku">
            </telerik:RadMenuItem>
            <%--<telerik:RadMenuItem Text="[%Odstranit%]" Value="delete">
            </telerik:RadMenuItem> --%>   
        </Items>
    </telerik:RadContextMenu>
    <input type="hidden" id="radGridClickedRowIndex" name="radGridClickedRowIndex" />
</asp:Content>

