﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AnketaList.ascx.cs"
    Inherits="KSPortal.Dotazniky.AnketaList" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/Dotazniky/AnketaControl.ascx" TagPrefix="uc1" TagName="AnketaControl" %>

<%--<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_anketalist">
    <AjaxSettings>
       
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>--%>

<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script>
        function ZobrazSablonyMenu(sender, args) {
            GetSablonyData(function (data)
            {
                BindContexMenuSablony(sender, data)
            });
        }

        function GetSablonyData(callback) {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/GetSablonyAnkety",
                async: true,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                error: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                success: function (response) {
                    callback(response.d);
                }

            });
        }

        var idAnketyProSablonu = 0;
        function BindContexMenuSablony(sender, data) {
            idAnketyProSablonu = sender.get_value();
            var RCM = $find('<%=RCM_sablony.ClientID%>');
            var menuItemClass = Telerik.Web.UI.RadMenuItem || Telerik.Web.UI.MobileMenuItem;
            RCM.trackChanges();
            RCM.get_items().clear();
            var i = 0;
            if (data.length > 0) {
                for (i in data) {
                    var d = data[i];
                    var childItem = new menuItemClass();
                    childItem.set_value(d.id);
                    childItem.set_text(d.nadpis);
                    childItem.set_cssClass('ksAkcmItem');
                    childItem.set_imageUrl(KSMaster.baseUrl + '/Skins/ikony/uicons-regular-rounded/svg/fi-rr-disk.svg');
                    RCM.get_items().insert(i, childItem);
                    childItem.get_element().title = 'Vytvoří z ankety šablonu a uloží ji jako již existující šablonu \'' + d.nadpis + '\', kterou přepíše';
                }
            }
            var zalozNovou = new menuItemClass();
            zalozNovou.set_value(-1);
            zalozNovou.set_text("Uložit jako novou šablonu");
            zalozNovou.set_cssClass('ksAkcmItem');
            zalozNovou.set_imageUrl(KSMaster.baseUrl + '/Skins/ikony/uicons-regular-rounded/svg/fi-rr-folder-plus-circle.svg');
            RCM.get_items().insert(i + 1, zalozNovou);
            zalozNovou.get_element().title = 'Vytvoří z ankety šablonu a uloží ji jako novou šablonu';

            var location = $telerik.getBounds(sender.get_element());
            RCM.showAt(location.x, location.y + location.height);
            RCM.commitChanges();
        }

        function BindContexMenuSablonyLoad(sender, data) {
            var RCM = $find('<%=RCM_sablony_load.ClientID%>');
            var menuItemClass = Telerik.Web.UI.RadMenuItem || Telerik.Web.UI.MobileMenuItem;
            RCM.trackChanges();
            RCM.get_items().clear();
            var i = 0;
            if (data.length > 0) {
                for (i in data) {
                    var d = data[i];
                    var childItem = new menuItemClass();
                    childItem.set_value(d.id);
                    childItem.set_text(d.nadpis);
                    RCM.get_items().insert(i, childItem);
                }
            }

            var location = $telerik.getBounds(sender.get_element());
            RCM.showAt(location.x, location.y + location.height);
            RCM.commitChanges();
        }

        function RCM_sablony_ItemClicked(sender, args) {
            var id = args.get_item().get_value();
            if (id == -1) {
                GetNadpisAnkety(idAnketyProSablonu, function (nazev) {
                    if (nazev) {
                        radprompt('Název:&nbsp;', function (arg) {
                            UlozSablonu(null, idAnketyProSablonu, arg);
                        }, 500, 0, null, 'Nová šablona', nazev);
                    }
                });
            }
            else {
                GetNadpisAnkety(id, function (nazev) {
                    if (nazev) {
                        radconfirm('Opravdu chcete tuto anketu uložit jako již uloženou šablonu \'' + nazev + '\' a tím ji přepsat?', function (arg) {
                            if (arg) {
                                UlozSablonu(id, idAnketyProSablonu, nazev);
                            }
                        }, 0, 0, null, 'Přepsání šablony');
                    }
                });
            }
        }

        function GetNadpisAnkety(id, callback) {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/GetNadpisAnkety",
                data: "{id: " + id + "}",
                async: true,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                error: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                success: function (response) {
                    callback(response.d);
                }
            });
        }

        function UlozSablonu(idSablony, idAnkety, nazev) {
            if (nazev) {
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/UlozSablonuAnkety",
                    data: "{idSablony: " + idSablony + ", idAnkety: " + idAnkety + ", nadpis: '" + nazev + "'}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (msg) {
                        radalert('Šablona byla uložena', 0, 0, 'Uložení šablony', null, null);
                    }
                });
            }
        }

        function TRB_from_template_Clicked(sender, args) {
            GetSablonyData(function (data) {
                BindContexMenuSablonyLoad(sender, data)
            });
        }

        function RCM_sablony_load_ItemClicked(sender, args) {
            var id = args.get_item().get_value();
            GetNadpisAnkety(id, function (nazev) {
                if (nazev) {
                    radconfirm('Opravdu chcete vytvořit anketu ze šablony \'' + nazev + '\'?', function (arg) {
                        if (arg) {
                            radprompt('Název:&nbsp;', function (zadaneJmeno) {
                                if (zadaneJmeno) {
                                    $.ajax({
                                        type: "POST",
                                        url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/VytvorAnketuZeSablony",
                                        data: "{idSablony: " + id + ", nadpis: '" + zadaneJmeno + "'}",
                                        async: true,
                                        contentType: "application/json",
                                        dataType: "json",
                                        failure: function (response) {
                                            KSMaster.showError(response.responseText, response.statusText);
                                        },
                                        error: function (response) {
                                            KSMaster.showError(response.responseText, response.statusText);
                                        },
                                        success: function (msg) {
                                            radalert('Anketa byla vytvořena', 0, 0, 'Nová anketa', null, null);
                                            var list = $find('<%=RLV_bull.ClientID%>');
                                            list.rebind();
                                        }
                                    });
                                }
                            }, 500, 0, null, 'Nová anketa', nazev);
                        }
                    }, 0, 0, null, 'Vytvoření nové ankety');
                }
            });
        }

        function RCM_sablony_load_Shown(sender, eventArgs) {
            <%--var items = sender.get_allItems();

            items.forEach(function (item) {
                var menuItemElement = item.get_element();

                // Přidání event listeneru pro pravé tlačítko myši (contextmenu)
                menuItemElement.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                    event.stopPropagation();

                    var RCM = $find('<%=RCM_sab_action.ClientID%>');

                    RCM.trackChanges();
                    RCM.get_items().forEach(function (itemAction) {
                        itemAction.set_value(item.get_value());
                    });

                    setTimeout(function () {
                        var location = $telerik.getBounds(menuItemElement);
                        RCM.showAt(location.x, location.y + location.height);
                        RCM.commitChanges();
                    }, 1000);
                });
            });--%>
        }

        function RCM_sab_action_ItemClicked(sender, args) {
            //var id = args.get_item().get_value();
            //alert('smaz ' + id);
        }

    </script>
</telerik:RadScriptBlock>
<telerik:RadContextMenu runat="server" ID="RCM_sablony" OnClientItemClicked="RCM_sablony_ItemClicked">
</telerik:RadContextMenu>
<telerik:RadContextMenu runat="server" ID="RCM_sablony_load"
    OnClientItemClicked="RCM_sablony_load_ItemClicked" OnClientShown="RCM_sablony_load_Shown">
</telerik:RadContextMenu>
<%--<telerik:RadContextMenu runat="server" ID="RCM_sab_action" OnClientItemClicked="RCM_sab_action_ItemClicked">
    <Items>
        <telerik:RadMenuItem Text="[%Delete%]">
        </telerik:RadMenuItem>
    </Items>
</telerik:RadContextMenu>--%>
<asp:Panel ID="P_bull" runat="server" CssClass="ksBlLv" Width="100%">
    <div class="anketyList">
        <div style="min-width: 625px; margin-right: 20px;">
            <telerik:RadListView runat="server" ID="RLV_bull" AllowPaging="true" AllowMultiItemEdit="false"
                OnNeedDataSource="RLV_bull_NeedDataSource" ItemPlaceholderID="ItemsPlaceHolder"
                OnItemDeleting="RLV_bull_ItemDeleting" OnItemDataBound="RLV_bull_ItemDataBound" DataKeyNames="id"
                InsertItemPosition="FirstItem" OnItemCommand="RLV_bull_ItemCommand">
                <LayoutTemplate>
                    <asp:Panel ID="P_edit_style" runat="server" Visible='true'>
                        <style type="text/css">
                            div.ksBlBullItem {
                                min-height: 125px;
                            }

                            .nadpis2Anketa {
                                font-weight: bold;
                                font-size: 12px;
                                text-align: left;
                                margin-bottom: 0.25em;
                                width: 100%;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                            }

                            div.ksBlFoto {
                                height: 120px !important;
                                /*margin-top: 6px;*/
                                margin: 6px;
                            }

                            .bullNadpis {
                                font-size: 19px;
                                color: black;
                            }

                            .displayNone {
                                display: none;
                            }


                            .otazkyEditButton {
                                align-self: center;
                                margin-left: 30%;
                                border: 1px solid var(--kscolor1);
                                border-radius: 5px;
                                width: 40%;
                                height: 30px;
                            }

                                .otazkyEditButton:hover {
                                    cursor: pointer;
                                }

                            .anketyList {
                                width: 100%;
                                display: flex;
                                flex-direction: row;
                                margin: auto;
                            }

                            .ksAkcmItem img {
                                height: 18px;
                                margin-top: -10px !important;
                            }

                            .RadWindow .rwPromptInputContainer {
                                width: -webkit-fill-available;
                            }

                            @media only screen and (max-width: 1000px) {
                                .anketyList {
                                    flex-direction: column;
                                }
                            }

                            .otazkaEdit, .odpovedTB, .selectVarianty, #close {
                                transition: 0.5s;
                                animation-name: otazkaEdit;
                                animation-duration: 0.5s;
                            }

                            @keyframes otazkaEdit {
                                0% {
                                    opacity: 0%;
                                }

                                100% {
                                    opacity: 100%;
                                }
                            }

                            .imageUpload {
                                display: none;
                            }

                        </style>
                    </asp:Panel>
                    <asp:Panel runat="server" ID="P_i_buttons" CssClass="ksBlButtInsert ksprvek" BackColor="white">
                        <div>
                            <kspwc:TRadButton runat="server" ID="TRB_add_new" ButtonType="StandardButton" OnClick="TRB_add_new_Click" Text="[%Přidat%]" ToolTip="[%Přidat nový záznam%]" Enabled='<%#Editacni && !KSProgram.Prava.ZamykaniAgend.GeneralZamekIsLocked()%>' Visible='<%#Editacni%>'>
                                <Icon PrimaryIconCssClass="fi fi-add" />
                            </kspwc:TRadButton>
                            <kspwc:TRadButton runat="server" ID="TRB_from_template" ButtonType="StandardButton" Text="[%Ze šablony%]" ToolTip="[%Přidá novou anketu z uložené šablony%]" Enabled='<%#Editacni && !KSProgram.Prava.ZamykaniAgend.GeneralZamekIsLocked()%>' Visible='<%#Editacni%>' 
                                AutoPostBack="false" OnClientClicked="TRB_from_template_Clicked">
                                <Icon PrimaryIconCssClass="fi fi-file-import" />
                            </kspwc:TRadButton>
                        </div>
                        <telerik:RadDataPager ID="RDP_page" runat="server" PagedControlID="RLV_bull" CssClass="ksBlPager"
                            PageSize="20">
                            <Fields>
                                <telerik:RadDataPagerSliderField />
                                <telerik:RadDataPagerPageSizeField PageSizes="20,50,100"></telerik:RadDataPagerPageSizeField>

                            </Fields>
                        </telerik:RadDataPager>
                    </asp:Panel>
                    <asp:PlaceHolder runat="server" ID="ItemsPlaceHolder"></asp:PlaceHolder>
                </LayoutTemplate>
                <ItemTemplate>
                    <fieldset class="ksBlFs">
                        <div class="ksBlBullItem">
                            <div id="body">
                                <div class="ksBlFoto" style="display: <%# Eval("id_image") != null ? "block" : "none"%>;" id="foto">
                                    <img style="max-width: 200px; max-height: 110px;" src="<%# Eval("ImageUrl") %>" />
                                    <div style="margin: 5px -4px;">
                                        <telerik:RadAsyncUpload runat="server" ID="RAU_Image" OnFileUploaded="RAU_Image_FileUploaded" HideFileInput="true"  AllowedFileExtensions=".jpeg,.jpg,.png" MultipleFileSelection="Disabled" MaxFileInputsCount="1" TemporaryFolder="~/Temp" CssClass="imageUpload" ToolTip="[%Změnit obrázek%]" />
                                    </div>
                                    <%--<kspwc:TRadButton runat="server" ID="TRB_image" Width="160" Height="107" Image-ImageUrl='<%# Eval("ImageUrl") %>' Visible='<%# Eval("id_image") != null %>'>
                            <Image EnableImageButton="true"  />
                        </kspwc:TRadButton>--%>
                                </div>
                                <div id="text">
                                    <asp:LinkButton runat="server" ID="LB_nadpis" Text='<%# Eval("nadpis") %>' OnClick="LB_nadpis_Click" Enabled="<%# !KSProgram.Prava.ZamykaniAgend.GeneralZamekIsLocked() %>" CssClass="bullNadpis"></asp:LinkButton>
                                    <asp:TextBox runat="server" ID="TB_nadpis" Text='<%# Eval("nadpis") %>' CssClass="bullNadpis displayNone" Width="70%"></asp:TextBox>
                                    <div style="position: absolute; top: 0px; right: 10px;" class="displayNone">
                                        <label style="width: 100px;" for="vehicle1">[%Anonymní%]</label>
                                        <input type="checkbox" id="CHB_anonym">
                                    </div>
                                    <br />
                                    <asp:Label runat="server" ID="Label_telo"> <%# Eval("telo")%></asp:Label>

                                    <asp:TextBox runat="server" ID="TB_telo" Text='<%# Eval("telo") %>' CssClass="displayNone" Width="80%" Wrap="true" TextMode="multiline"></asp:TextBox>
                                    <div runat="server" id="AaD" style="margin-top: 20px;">
                                        <asp:Label runat="server" ID="L_adr" Text="[%Adresáti%]: " Visible="true"><%# Eval("s_Adresats") %></asp:Label>
                                        <div class="displayNone" style="width: 80%;">
                                            <%--kvůli js visibilitě--%>
                                            <telerik:RadMultiSelect runat="server" ID="RMS_e_adresats" Filter="Contains" Skin="Metro" CssClass="ksBlMultiSelect" Placeholder="Přidejte adresáty"
                                                AutoClose="false" DataValueField="key" DataTextField="nazev" Width="100%" AutoWidth="true" MinLength="1">
                                                <ClientEvents OnChange="RMS_adresats_OnChange" OnDataBound="RMS_adresats_OnChange" />
                                                <WebServiceClientDataSource runat="server" AutoSync="true">
                                                    <WebServiceSettings>
                                                        <Select Url="../WebServices/AutoCompleteService.asmx/GetAdresatsOfBulletins" RequestType="Post" DataType="JSON" ContentType="application/json; charset=utf-8" />
                                                    </WebServiceSettings>
                                                    <GroupExpressions>
                                                        <telerik:ClientDataSourceGroupExpression FieldName="nazev_typ" />
                                                    </GroupExpressions>
                                                    <Schema DataName="d">
                                                        <Model>
                                                            <%-- ID neoznačuje id modelu ale sloupec obsahující klíč--%>
                                                            <telerik:ClientDataSourceModelField FieldName="typ_org_j" DataType="Number" Editable="False" Nullable="false" />
                                                            <telerik:ClientDataSourceModelField FieldName="org_j" DataType="String" Editable="False" />
                                                            <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
                                                            <telerik:ClientDataSourceModelField FieldName="nazev_typ" DataType="String" Editable="False" />
                                                            <telerik:ClientDataSourceModelField FieldName="key" DataType="String" Editable="False" />
                                                        </Model>
                                                    </Schema>
                                                </WebServiceClientDataSource>
                                            </telerik:RadMultiSelect>
                                        </div>
                                        <div style="width: fit-content; bottom: 5px; left: 5px; position: absolute" id="datum">
                                            <div>
                                                <kspwc:TRadDatePicker runat="server" ID="TRDP_od" SelectedDate='<%# Eval("datum_od") %>' Enabled="false">
                                                    <DateInput EmptyMessage="[%Publikovat od%]"></DateInput>
                                                </kspwc:TRadDatePicker>
                                                <kspwc:TRadDatePicker runat="server" ID="TRDP_do" SelectedDate='<%# Eval("datum_do") %>' Enabled="false">
                                                    <DateInput EmptyMessage="[%Publikovat do%]"></DateInput>
                                                </kspwc:TRadDatePicker>
                                            </div>
                                            <div class="displayNone">
                                                <kspwc:TRadDatePicker runat="server" ID="TRDP_od_edit" SelectedDate='<%# Eval("datum_od") %>' Enabled="true">
                                                    <DateInput EmptyMessage="[%Publikovat od%]"></DateInput>
                                                </kspwc:TRadDatePicker>
                                                <kspwc:TRadDatePicker runat="server" ID="TRDP_do_edit" SelectedDate='<%# Eval("datum_do") %>' Enabled="true">
                                                    <DateInput EmptyMessage="[%Publikovat do%]"></DateInput>
                                                </kspwc:TRadDatePicker>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <asp:Panel runat="server" ID="P_e_butt" CssClass="ksBlButtEdit">
                                <kspwc:TRadButton runat="server" ID="TRB_vyhodnot" ButtonType="StandardButton" CommandName="ShowResults" Text="[%Výsledky%]" ToolTip="[%Výsledky ankety%]">
                                    <Icon PrimaryIconCssClass="fi fi-stats" />
                                </kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_Editovat" ButtonType="StandardButton" CommandName="Edit" Text="[%Editovat%]" ToolTip="[%Upravit anketu%]" OnClientClicked="EditujAnketu" AutoPostBack="false">
                                    <Icon PrimaryIconCssClass="fi fi-edit" />
                                </kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_Uloz" ButtonType="StandardButton" CommandName="Save" Text="[%Uložit%]" ToolTip="[%Uložit změny%]" OnClientClicked="UlozitAnketu" CssClass="displayNone kstlacitko" AutoPostBack="true">
                                    <Icon PrimaryIconCssClass="fi fi-edit" />
                                </kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_Sablona" ButtonType="StandardButton" CommandName="Save" Text="[%Uložit šablonu%]" Value='<%# Eval("id") %>' ToolTip="[%Uloží anketu jako šablonu pro použití při tvorbě nové ankety%]"
                                    OnClientClicked="ZobrazSablonyMenu" CssClass="kstlacitko" AutoPostBack="false">
                                    <Icon PrimaryIconCssClass="fi fi-template" />
                                </kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_Reset" ButtonType="StandardButton" CommandName="Reset" Text="[%Promazat%]" ToolTip="[%Promazat odpovědi ankety%]" AutoPostBack="true" Visible="true" ConfirmTitle="[%Zmazání odpovědí%]" ConfirmText="[%Budou smazány všechny zodpovězené otázky této ankety. Anketu pak bude možné editovat. Opravdu je chcete smazat?%]">
                                    <Icon PrimaryIconCssClass="fi fi-rotate-right" />
                                </kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_delete" ButtonType="StandardButton" CommandName="Delete" Text="[%Smazat%]" ToolTip="[%Smazat záznam%]" ConfirmText="[%Smazat záznam?%]">
                                    <Icon PrimaryIconCssClass="fi fi-trash" />
                                </kspwc:TRadButton>
                            </asp:Panel>

                        </div>
                    </fieldset>
                </ItemTemplate>
            </telerik:RadListView>
        </div>

        <div id="otazkyEdit" style="width: 600px; margin: 25px; display: none; margin-top: 50px;">
            <div id="seznamOtazekEdit">
                <%--<div id="otazkaDiv0" class="otazkaEdit ksprvek">
                    <div style="float: right">
                        <label for='povinny'>Povinná otázka</label>
                        <input class="checkboxPovinny" id='povinnyCheck' type='checkbox' name='povinny'>
                    </div>
                    <table class="otazkaNadpis">
                        <tr>
                            <td>
                                <textarea id='nadpisOtazky' class='nadpis1Anketa' placeholder='Zadejte text otázky' rows='2' cols='20'></textarea>
                            </td>
                        </tr>
                    </table>
                    <hr class="diver" />
                    <input id="novaodpovedAdd" type='button' value="+ Nová odpověď" class="buttonText" onclick="novaOdpoved(this);" />
                    <br />
                    <br />
                    <div class="seznamOdpovedi">
                        <table id="T_odpoved1">
                            <tr>
                                <td>
                                    <select id="TDD_odpovedi" class="selectVarianty">
                                        <option value="checkbox">Checkbox</option>
                                        <option value="radio">RadioButton</option>
                                        <option value="text">Text</option>
                                    </select>

                                </td>
                                <td class="odpoved">
                                    <input type="text" id="RTB_odpoved" class="odpovedTB" />
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>--%>
                <%-- <div style="position: absolute">
                    <svg width="500" height="500"><line x1="50" y1="50" x2="350" y2="350" stroke="black"/></svg>
                </div>--%>
            </div>
            <%-- JH 8.7.2022 --%>
            <input id="novaOtazkanazev" type="button" class="otazkyEditButton color1" value="+ Nová otázka" onclick="novaOtazka('seznamOtazekEdit');" />
        </div>

    </div>
    <uc1:AnketaControl runat="server" ID="AnketaControl" />
</asp:Panel>





