﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="HodnoceniCileTypy.aspx.cs" Inherits="KSPortal.Sestavy.HodnoceniCileTypy" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .akceCombo {
            padding: 2px 2px 0px 2px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RAMP" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AllowPaging="True" AllowSorting="True" AutoFilterWidth="True" AutoFilterControlWidth="false" AutoGenerateColumns="False" ShowGroupPanel="True" UseSaveSetting="False" OnNeedDataSource="TRadGrid1_NeedDataSource" OnItemDataBound="TRadGrid1_ItemDataBound" ShowFooter="true">
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="True">
        </GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" ShowGroupFooter="true" EnableHeaderContextMenu="true" EnableHeaderContextAggregatesMenu="true" EnableHeaderContextFilterMenu="true">
            <PagerStyle PageSizes="10,30,50,100,300,500,1000" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GCIC" runat="server">
                    <RebindButton runat="server" OnClick="GCIC_rebind_Click">
                    </RebindButton>
                    <ContentTemplate>
                        <asp:ObjectDataSource ID="odsAkce" runat="server" SelectMethod="SeznamAkce" TypeName="KSProgram.Hodnoceni.PrenosMzdy"></asp:ObjectDataSource>
                        <kspwc:TRadComboBox runat="server" ID="TRCB_akce" DropDownAutoWidth="Enabled" DataSourceID="odsAkce" DataTextField="nazev" DataValueField="id" CssClass="akceCombo" OnSelectedIndexChanged="TRCB_akce_SelectedIndexChanged" AutoPostBack="false">
                        </kspwc:TRadComboBox>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <ColumnGroups>
                <telerik:GridColumnGroup Name="zam" HeaderText="[%Zaměstnanec%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="pom" HeaderText="[%Pracovní poměr%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="cil" HeaderText="[%Cíl%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="hod" HeaderText="[%Hodnocení%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="castky" HeaderText="[%Částky%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="krivka" ParentGroupName="hod" HeaderText="[%Křivka%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="vaha" ParentGroupName="cil" HeaderText="[%Váha%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="str_zam" ParentGroupName="zam" HeaderText="[%Kmenové středisko%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="str_pom" ParentGroupName="pom" HeaderText="[%Pracovní středisko%]"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridNumericColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" UniqueName="os_cislo" ColumnGroupName="zam" DecimalDigits="0" DataType="System.Decimal"></telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo" ColumnGroupName="zam"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" UniqueName="jmeno" ColumnGroupName="zam" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="kmen_str" HeaderText="[%Číslo%]" UniqueName="kmen_str" ColumnGroupName="str_zam" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="kmen_str_nazev" HeaderText="[%Název%]" UniqueName="kmen_str_nazev" ColumnGroupName="str_zam" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="cislo_pom" HeaderText="[%Číslo%]" UniqueName="cislo_pom" ColumnGroupName="pom" DecimalDigits="0" DataType="System.Int16"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Číslo%]" UniqueName="prac_str" ColumnGroupName="str_pom" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str_nazev" HeaderText="[%Název%]" UniqueName="prac_str_nazev" ColumnGroupName="str_pom" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="os_hodn" HeaderText="[%Os. hodnoceni%]" UniqueName="os_hodn" ColumnGroupName="pom" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ### ##0.##}"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="nazev_cile" HeaderText="[%Název%]" UniqueName="nazev_cile" ColumnGroupName="cil" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="typ_cile" HeaderText="[%Typ%]" UniqueName="typ_cile" ColumnGroupName="cil" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="kumulace" HeaderText="[%Kumulace%]" UniqueName="kumulace" ColumnGroupName="cil" DataType="System.String"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="vaha" HeaderText="[%Poměr%]" UniqueName="vaha" ColumnGroupName="vaha" DecimalDigits="0" DataType="System.Int16" DataFormatString="{0:### ### ##0.##}" Aggregate="Sum"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="vaha_proc" HeaderText="[%%%]" UniqueName="vaha_proc" ColumnGroupName="vaha" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ### ##0.00}" Aggregate="Sum"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="hodnota" HeaderText="[%Hodnota%]" UniqueName="hodnota" ColumnGroupName="hod" DecimalDigits="0" DataType="System.Decimal" DataFormatString="{0:### ### ##0.##}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="hodnoceni" HeaderText="[%Hodnocení%]" UniqueName="hodnoceni" ColumnGroupName="hod" DecimalDigits="0" DataType="System.Int32" DataFormatString="{0:### ### ##0.##}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="plneni" HeaderText="[%Plnění %%]" UniqueName="plneni" ColumnGroupName="hod" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ### ##0.00}" Aggregate="Avg"></telerik:GridNumericColumn>
                <telerik:GridTemplateColumn DataField="nazev_krivky" HeaderText="[%Název%]" UniqueName="nazev_krivky" ColumnGroupName="krivka" DataType="System.String">
                    <ItemTemplate>
                        <asp:Label ID="L_Krivka_cile" runat="server" Text='<%# Eval("nazev_krivky") %>'></asp:Label>
                        <telerik:RadToolTip ID="RTT_krivka" runat="server" TargetControlID="L_Krivka_cile" Width="170px">
                            <asp:Label ID="l_popis" runat="server" Text='<%# Eval("popis_krivky") %>'></asp:Label>
                        </telerik:RadToolTip>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="plneni_krivka" HeaderText="[%Plnění %%]" UniqueName="plneni_krivka" ColumnGroupName="krivka" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ##0.00}" Aggregate="Avg"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="vyplatit" HeaderText="[%Vyplatit%]" UniqueName="vyplatit" ColumnGroupName="castky" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ##0.00}" Aggregate="Sum"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="vyplaceno" HeaderText="[%Vyplaceno%]" UniqueName="vyplaceno" ColumnGroupName="castky" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ##0.00}" Aggregate="Sum"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zadrzne" HeaderText="[%Zádržné%]" UniqueName="zadrzne" ColumnGroupName="castky" DecimalDigits="2" DataType="System.Decimal" DataFormatString="{0:### ##0.00}" Aggregate="Sum"></telerik:GridNumericColumn>
            </Columns>
            <GroupByExpressions>
                <telerik:GridGroupByExpression>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="os_cislo" HeaderText="[%Osobní číslo%]" SortOrder="Ascending" />
                    </GroupByFields>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="os_cislo" HeaderText="[%Osobní číslo%]" />
                        <telerik:GridGroupByField FieldName="jmeno" HeaderText="[%Jméno%]" />
                    </SelectFields>
                </telerik:GridGroupByExpression>
                <telerik:GridGroupByExpression>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="typ_cile" HeaderText="[%Typ cíle%]" SortOrder="Ascending" />
                    </GroupByFields>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="typ_cile" HeaderText="[%Typ cíle%]" SortOrder="Ascending" />
                    </SelectFields>
                </telerik:GridGroupByExpression>
            </GroupByExpressions>
        </MasterTableView>
    </kspwc:TRadGrid>

</asp:Content>
