﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="HodnoceniPrenosMzdy.aspx.cs" Inherits="KSPortal.Pis.HodnoceniPrenosMzdy" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .thisRg .rgFilterRow .rgFilterBox, .thisRg .rgFilterRow .riSingle {
            width: calc(100% - 21px) !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
        <script type="text/javascript">
            function handleEnterKey(element, ev) {
                if (ev.keyCode == 13) {
                    preventEvent(ev);
                    var grid = $find(element.id);
                    var batchManager = grid.get_batchEditingManager();
                    var tableView = grid.get_masterTableView();
                    batchManager._tryCloseEdits(tableView);
                    setTimeout(function () {
                        batchManager.saveChanges(grid.get_masterTableView());
                    })
                }
            }

            function preventEvent(e) {
                var evt = e ? e : window.event;
                if (evt.stopPropagation) evt.stopPropagation();
                if (evt.preventDefault) evt.preventDefault();
                if (evt.cancelBubble != null) evt.cancelBubble = true;
                if (evt.stopImmediatePropagation) evt.stopImmediatePropagation();
                evt.returnValue = false;
            }

        </script>
    </telerik:RadCodeBlock>
    <%--<asp:Label ID="Nadpis" runat="server" CssClass="nadpis1" Text="[%Přenos do mezd%]"></asp:Label>--%>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="ddlbAkce">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGridPrenosMzdy"
                        UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadGridPrenosMzdy">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGridPrenosMzdy"
                        UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <asp:ObjectDataSource ID="odsAkce" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SeznamAkce" TypeName="KSProgram.Hodnoceni.PrenosMzdy"></asp:ObjectDataSource>

    <div style="padding-bottom: 8px;">
        <kspwc:TDropDown ID="ddlbAkce" runat="server" DataSourceID="odsAkce" DataTextField="nazev" DataValueField="id" AutoPostBack="true" OnSelectedIndexChanged="ddlbAkce_SelectedIndexChanged"></kspwc:TDropDown>
    </div>
    <kspwc:TRadGrid ID="RadGridPrenosMzdy" runat="server" onkeydown="handleEnterKey(this, event);" IdPravaEditace="290" MasterTableView-Caption="[%Přenos do mezd%]"
        OnNeedDataSource="RadGridPrenosMzdy_NeedDataSource" AllowSorting="True" AutoGenerateColumns="False" OnBatchEditCommand="RadGridPrenosMzdy_BatchEditCommand" AllowPaging="True" ShowGroupPanel="True" CssClass="thisRg ksprvek">
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="True"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView DataKeyNames="id,vcastka" EditMode="Batch" CommandItemDisplay="Top" ShowFooter="True">
            <RowIndicatorColumn Visible="False">
            </RowIndicatorColumn>
            <ExpandCollapseColumn Created="True">
            </ExpandCollapseColumn>
            <Columns>
                <telerik:GridNumericColumn DataField="os_cislo" FilterControlAltText="Filter os_cislo column"
                    HeaderText="[%Os.číslo%]" ReadOnly="True" UniqueName="os_cislo" DataType="System.Decimal">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo" >
                    <HeaderStyle Width="70px"></HeaderStyle>
                    <ItemStyle Width="70px" />
                </kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="prijmeni" FilterControlAltText="Filter prijmeni column"
                    HeaderText="[%Příjmení%]" ReadOnly="True" UniqueName="prijmeni">
                    <HeaderStyle Width="90px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column"
                    HeaderText="[%Jméno%]" ReadOnly="True" UniqueName="jmeno">
                    <HeaderStyle Width="90px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="titul" FilterControlAltText="Filter titul column"
                    HeaderText="[%Titul%]" ReadOnly="True" UniqueName="titul">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="cislo_pom" FilterControlAltText="Filter cislo_pom column"
                    HeaderText="[%Č.Poměru%]" ReadOnly="True" UniqueName="cislo_pom" DataType="System.Int16">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="kmen_str" FilterControlAltText="Filter kmen_str column"
                    HeaderText="[%Kmen.středisko%]" ReadOnly="True" UniqueName="kmen_str">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str" FilterControlAltText="Filter prac_str column"
                    HeaderText="[%Prac.středisko%]" ReadOnly="True" UniqueName="prac_str">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_misto" FilterControlAltText="Filter prac_misto column"
                    HeaderText="[%Prac.místo%]" ReadOnly="True" UniqueName="prac_misto">
                    <HeaderStyle Width="200px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="kod" FilterControlAltText="Filter kod column"
                    HeaderText="[%Kód%]" ReadOnly="True" UniqueName="kod" DataType="System.Int32">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="vkoeficient" FilterControlAltText="Filter vkoeficient column"
                    HeaderText="[%Koeficient%]" ReadOnly="True" UniqueName="vkoeficient" DataType="System.Decimal" DecimalDigits="2" Aggregate="Avg">
                    <HeaderStyle Width="60px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="vcastka" FilterControlAltText="Filter vcastka column"
                    HeaderText="[%Vypočteno%]" ReadOnly="True" UniqueName="vcastka" DataType="System.Decimal" NumericType="Currency" DecimalDigits="0" Aggregate="Sum">
                    <HeaderStyle Width="90px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="castka" FilterControlAltText="Filter castka column"
                    HeaderText="[%Upraveno%]" ReadOnly="False" UniqueName="castka" DataType="System.Decimal" NumericType="Currency" MinValue="0" MaxValue="10000000" DecimalDigits="0" Aggregate="Sum">
                    <HeaderStyle Width="90px"></HeaderStyle>
                </telerik:GridNumericColumn>
                <telerik:GridCalculatedColumn Aggregate="Sum" DataType="System.Decimal" DataFields="castka, vcastka" Expression="{0}-{1}" FilterControlAltText="Filter uprava column" HeaderText="[%Úprava%]" UniqueName="uprava">
                    <HeaderStyle Width="90px"></HeaderStyle>
                </telerik:GridCalculatedColumn>
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="gcic" SaveButton-Visible="true">
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
