﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="SkoleniDochazka.aspx.cs"
    Inherits="KSPortal.Pis.SkoleniDochazka" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .ksGrafProc {
            min-width: 70px;
        }

        div.ksGrafProc {
            border: 1px solid var(--kscolor1);
        }

            div.ksGrafProc > span {
                position: absolute;
            }

            div.ksGrafProc > div {
                background-color: var(--kscolor1);
                color: var(--kscolor1text);
            }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadScriptBlock ID="RadScriptBlock2" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //<![CDATA[
            var p_cislo;
            function trb_ctecka_clicked(sender, args) {
                p_cislo = args.get_commandArgument();

                PageMethods.getNazevAkce(p_cislo, nazevNacten);
            }

            function nazevNacten(nazev) {
                var window = $find("<%=modalPopup.ClientID %>");
                window.set_title(nazev);
                window.show();
                var textbox = $find("<%=rtb_ctecka.ClientID %>");
                textbox.clear();
                textbox.focus();

            }

            function ucastZapsana(hlaseni) {
                var label = $get('ksreadcard');
                label.innerText = hlaseni;
                var textbox = $find("<%=rtb_ctecka.ClientID %>");
                textbox.clear();
                textbox.focus();
            }

            function ucastNezapsana() {
                var label = $get('ksreadcard');
                label.innerText = "[%Při zapisování nastala neznámá chyba.%]";
                var textbox = $find("<%=rtb_ctecka.ClientID %>");
                textbox.clear();
                textbox.focus();
            }

            function hidenbutton_clicked(sender, args) {
                var textbox = $find("<%=rtb_ctecka.ClientID %>");
                var code = textbox.get_value();
                PageMethods.zapsatUcast(p_cislo, code, ucastZapsana, ucastNezapsana);
            }

            function window_close(sender, args) {
                var button = $find("<%=hidenbutton2.ClientID %>");
                button.click();
            }


            //]]>
        </script>
    </telerik:RadScriptBlock>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="hidenbutton2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <telerik:RadPersistenceManagerProxy ID="RPMP" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRadGrid_sestava" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>

    <%--<asp:Label ID="Label" runat="server" Text="[%Prezenční listina%]" CssClass="nadpis1"></asp:Label>--%>

    <kspwc:TRadGrid ID="TRadGrid_sestava" runat="server" AllowPaging="True" AutoFilterWidth="true"
         AllowSorting="true" AutoGenerateColumns="false" EnableHeaderContextMenu="true" MasterTableView-Caption="[%Prezenční listina%]"
        OnNeedDataSource="TRadGrid_sestava_NeedDataSource" OnDetailTableDataBind="TRadGrid_sestava_DetailTableDataBind" AutoFilterControlWidth="false">
        <MasterTableView CommandItemDisplay="Top" ShowFooter="true" DataKeyNames="p_cislo" EnableHierarchyExpandAll="true" RetainExpandStateOnRebind="true" EnableHeaderContextAggregatesMenu="true">
            <DetailTables>
                <telerik:GridTableView Name="Seznam účastníků" Width="100%" DataKeyNames="os_cislo">
                    <Columns>
                        <telerik:GridNumericColumn SortExpression="os_cislo" HeaderText="[%Osobní číslo%]" DataField="os_cislo">
                        </telerik:GridNumericColumn>
                        <telerik:GridBoundColumn SortExpression="jmeno" HeaderText="[%Jméno%]" DataField="jmeno">
                        </telerik:GridBoundColumn>
                        <telerik:GridBoundColumn SortExpression="prijmeni" HeaderText="[%Příjmení%]" DataField="prijmeni">
                        </telerik:GridBoundColumn>
                        <telerik:GridDateTimeColumn SortExpression="prezence_kdy" HeaderText="[%Přítomen od%]" DataType="System.DateTime" DataField="prezence_kdy">
                        </telerik:GridDateTimeColumn>
                        <telerik:GridTemplateColumn HeaderStyle-Width="20px" HeaderText="[%Přítomen%]" DataField="prezence" DataType="System.Boolean">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="trb_prezence" ButtonType="LinkButton" ToggleType="CheckBox" Checked='<%# Eval("prezence") %>' OnCheckedChanged="trb_prezence_CheckedChanged">
                                    <ToggleStates>
                                        <telerik:RadButtonToggleState Text="[%Je přítomen%]"  Value="true"/>
                                        <telerik:RadButtonToggleState Text="[%Není přítomen%]"  Value="false"/>
                                    </ToggleStates>
                                </kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                </telerik:GridTableView>
            </DetailTables>

            <Columns>
                <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název akce%]" SortExpression="nazev" FilterControlAltText="Filter nazev column" />
                <telerik:GridBoundColumn DataField="osv_nazev" HeaderText="[%Název vzd. aktivity%]" SortExpression="osv_nazev" FilterControlAltText="Filter osv_nazev column" />
                <telerik:GridBoundColumn DataField="lektor" HeaderText="[%Lektor / Dodavatel šk.%]" SortExpression="lektor" FilterControlAltText="Filter lektor column" />
                <telerik:GridBoundColumn DataField="ucebna" HeaderText="[%Místo%]" SortExpression="ucebna" FilterControlAltText="Filter ucebna column" />
                <telerik:GridDateTimeColumn DataField="dat_od" DataFormatString="{0:d.M.yyyy}" HeaderText="[%Termín%]" SortExpression="dat_od" FilterControlAltText="Filter dat_od column" />
                <telerik:GridDateTimeColumn DataField="cas_od" DataFormatString="{0:HH:mm}" HeaderText="[%Čas%]" SortExpression="cas_od" FilterControlAltText="Filter cas_od column" />
                <telerik:GridNumericColumn DataField="prihlasenych" HeaderText="[%Přihlášených%]" DataType="System.Int32" SortExpression="prihlasenych" FilterControlAltText="Filter prihlasenych column"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="max_prihlasenych" HeaderText="[%Max.%]" DataType="System.Int16" SortExpression="max_prihlasenych" FilterControlAltText="Filter max_prihlasenych column"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="ucast" HeaderText="[%Účast%]" DataType="System.Int32" SortExpression="ucast" FilterControlAltText="Filter ucast column"></telerik:GridNumericColumn>
                <telerik:GridTemplateColumn DataField="proc" UniqueName="temp" HeaderText="[%Účast%] %" AllowFiltering="true" AllowSorting="true" SortExpression="proc" FilterControlAltText="Filter proc column">
                    <HeaderStyle Width="100px" CssClass="ksGrafProc" />
                    <ItemTemplate>
                        <div class="ksGrafProc" align="left">
                            <span><%# Eval("proc") %> %</span>
                            <div style="width: <%# Eval("proc") %>%;">&nbsp</div>
                        </div>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn HeaderStyle-Width="20px">
                    <ItemTemplate>
                        <kspwc:TRadButton runat="server" ID="trb_ctecka" ButtonType="LinkButton" Text="[%Docházka kartou%]" AutoPostBack="false" OnClientClicked="trb_ctecka_clicked" CommandArgument='<%# Eval("p_cislo") %>'></kspwc:TRadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>

            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Visible="True" DateControl="TRadObdobiInterval">
                    <ExportButton ID="ExportButton1" runat="server" />
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

    <telerik:RadWindow ID="modalPopup" runat="server" Width="380px" Height="250px" Modal="true" Behaviors="Close" OnClientClose="window_close">
        <ContentTemplate>
            <asp:Panel ID="p_window" runat="server" DefaultButton="hidenbutton">
                <p style="text-align: center; font-size: medium;">
                    [%Načtěte kartu%]
                </p>
                <p style="text-align: center;">
                    <telerik:RadTextBox Width="260px" ID="rtb_ctecka" runat="server" AutoPostBack="false" TextMode="Password">
                    </telerik:RadTextBox>
                </p>
                <p>
                    <kspwc:TRadButton runat="server" ID="hidenbutton" CssClass="hidden" AutoPostBack="false" OnClientClicked="hidenbutton_clicked">
                    </kspwc:TRadButton>
                    <kspwc:TRadButton runat="server" ID="hidenbutton2" CssClass="hidden" AutoPostBack="true" OnClick="hidenbutton2_Click">
                    </kspwc:TRadButton>
                </p>
                <p style=" text-align: center; font-size: medium;">
                    <label id="ksreadcard"></label>
                </p>
            </asp:Panel>
        </ContentTemplate>
    </telerik:RadWindow>

</asp:Content>
