﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="SouhrnOdmen.aspx.cs" Inherits="KSPortal.Sestavy.SouhrnOdmen" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="gv_odmeny">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="gv_odmeny" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <div>
        <kspwc:TRadObdobi ID="Obdobi" runat="server" AutoPostBack="true">
            <Picker ID="Picker1" runat="server">
                <DateInput ReadOnly="true">
                </DateInput>
            </Picker>
        </kspwc:TRadObdobi>
    </div>
    <asp:ObjectDataSource runat="server" ID="ds_odmeny" TypeName="KSProgram.Pozadavky.Pozadavekodmeny"
        SelectMethod="GetOdmeny" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:ControlParameter ControlID="Obdobi" Name="ad_obdobi" PropertyName="SelectedDate"
                Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource> 
    <br />
    <asp:Label ID="lab_nadpis" runat="server" Text="[%Požadavky na odměny%]" SkinID="Title1" ></asp:Label>
   <%-- IsExporting="False" --%>
    <kspwc:TRadGrid runat="server" ID="gv_odmeny"  DataSourceID="ds_odmeny"
        AutoGenerateColumns="False" AllowPaging="True" PageSize="50" AllowSorting="True"
        AllowFilteringByColumn="True" GroupPanelPosition="Top" ShowGroupPanel="True"
        EnableHierarchyExpandAll="True" 
        ondatabound="gv_odmeny_DataBound" 
        onitemdatabound="gv_odmeny_ItemDataBound">
        <ClientSettings ReorderColumnsOnClient="True" AllowDragToGroup="True" AllowColumnsReorder="True">
            <Selecting AllowRowSelect="false"></Selecting>            
        </ClientSettings>
        <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
        <ExportSettings IgnorePaging="true" ExportOnlyData="true" OpenInNewWindow="true" SuppressColumnDataFormatStrings="true">
        </ExportSettings>
        <MasterTableView DataSourceID="ds_odmeny" TableLayout="Fixed" CommandItemDisplay="Top"
            ShowGroupFooter="true" AllowMultiColumnSorting="true" ShowFooter="true">
            <ColumnGroups>
                <telerik:GridColumnGroup Name="vseobecne" HeaderText="" HeaderStyle-HorizontalAlign="Center" />
                <telerik:GridColumnGroup Name="n_plus_1" HeaderText="[%Schvalování%] N+1" HeaderStyle-HorizontalAlign="Center" />
                <telerik:GridColumnGroup Name="n_plus_2" HeaderText="[%Schvalování%] N+2" HeaderStyle-HorizontalAlign="Center" />
            </ColumnGroups>
            <Columns>
                <telerik:GridBoundColumn DataField="os_cislo" UniqueName="col_os_cislo" HeaderText="[%Osobní číslo%]"
                    ColumnGroupName="vseobecne">
                   <ItemStyle Width="150" />
                    <HeaderStyle Width="150" HorizontalAlign="Right" />
                    <FooterStyle Width="150" Font-Bold="true" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cislo_pom" UniqueName="col_cislo_pom" HeaderText="[%Číslo poměru%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno_cele" UniqueName="col_jmeno_cele" HeaderText="[%Jméno%]"
                    Aggregate="Count" FooterText="[%Počet položek%]: " ColumnGroupName="vseobecne">
                    <ItemStyle Width="150" />
                    <HeaderStyle Width="150" />
                    <FooterStyle Width="150" Font-Bold="true" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="kod" UniqueName="col_kod" HeaderText="[%Kód%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="150" />
                    <HeaderStyle Width="150" />
                    <FooterStyle Width="150" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="dny" UniqueName="col_dny" HeaderText="[%Dny%]"
                    Aggregate="Sum" FooterText=" " ColumnGroupName="vseobecne" DataFormatString="{0:N1}">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" Font-Bold="true" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="hodiny" UniqueName="col_hodiny" HeaderText="[%Hodiny%]"
                    Aggregate="Sum" FooterText=" " ColumnGroupName="vseobecne"  DataFormatString="{0:N2}">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" Font-Bold="true" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="sazba" UniqueName="col_sazba" HeaderText="[%Sazba%]"
                    ColumnGroupName="vseobecne" >
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="castka" UniqueName="col_castka" HeaderText="[%Částka%]"
                    Aggregate="Sum" FooterText=" " ColumnGroupName="vseobecne" >
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" Font-Bold="true" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str" UniqueName="col_prac_str" HeaderText="[%Prac. stř.%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="dat_vytvoreni" UniqueName="col_dat_vytvoreni"
                    HeaderText="[%Datum zadání%]" DataFormatString="{0:d}" ColumnGroupName="vseobecne">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="stav" UniqueName="col_stav" HeaderText="[%Stav%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="zadavatel" UniqueName="col_zadavatel" HeaderText="[%Zadavatel%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="150" />
                    <HeaderStyle Width="150" />
                    <FooterStyle Width="150" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="id_poz" UniqueName="col_id_poz" HeaderText="[%ID požadavku%]"
                    ColumnGroupName="vseobecne">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="dat_schvaleni1" UniqueName="col_dat_schvaleni1"
                    HeaderText="[%Datum%]" DataFormatString="{0:d}" ColumnGroupName="n_plus_1">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="os_cislo_schvaleni1" UniqueName="col_os_cislo_schvaleni1"
                    HeaderText="[%Schvalovatel%]" ColumnGroupName="n_plus_1">
                    <ItemStyle Width="150" />
                    <HeaderStyle Width="150" />
                    <FooterStyle Width="150" />                   
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="dat_schvaleni2" UniqueName="col_dat_schvaleni2"
                    HeaderText="[%Datum%]" DataFormatString="{0:d}" ColumnGroupName="n_plus_2">
                    <ItemStyle Width="95" />
                    <HeaderStyle Width="95" />
                    <FooterStyle Width="95" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="os_cislo_schvaleni2" UniqueName="col_os_cislo_schvaleni2"
                    HeaderText="[%Schvalovatel%]" ColumnGroupName="n_plus_2">
                    <ItemStyle Width="150" />
                    <HeaderStyle Width="150" />
                    <FooterStyle Width="150" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="poznamka" UniqueName="col_poznamka" DataType="System.String"
                    HeaderText="[%Poznámka%]" >
                    <ItemStyle Width="200" />
                    <HeaderStyle Width="200" />
                    <FooterStyle Width="200" />
                </telerik:GridBoundColumn>
                <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
            </Columns>
            <CommandItemTemplate>
               <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="True" RebindButton-Visible="True" FilterButton-Visible="False">
                            <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelXlsxItem="true" ShowExportToExcelHtmlItem="false" />
                        </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
