﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Zamestnanec_PomuckyNarokZam" CodeBehind="PomuckyNarokZam.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="server">

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_Uloz">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_pomucky_narok"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Vydane">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_Vydane"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <asp:ObjectDataSource ID="ODS_VelikostiPomucky" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetVelikostiPomucky" TypeName="KSProgram.Personal.Pomucky">
        <SelectParameters>
            <asp:SessionParameter Name="aIdPomucky" SessionField="id_pomucky" Type="String" />
            <asp:Parameter Name="aPodlePohlavi" Type="Boolean" DefaultValue="true" />
        </SelectParameters>
    </asp:ObjectDataSource>


    <kspwc:TRadGrid ID="TRadGrid_pomucky_narok" runat="server" AllowPaging="True" ShowGroupPanel="false" OnItemCommand="TRadGrid_pomucky_narok_ItemCommand" OnItemDataBound="TRadGrid_pomucky_narok_ItemDataBound"
        AllowSorting="true" AutoGenerateColumns="false" CssClass="ksprvek" OnNeedDataSource="TRadGrid_pomucky_narok_NeedDataSource"
        AutoFilterControlWidth="false" MasterTableView-ShowFooter="False">
        <MasterTableView CommandItemDisplay="Top" Caption="[%Nárok na pomůcky%]" PageSize="10" EditMode="InPlace">
            <Columns>
                <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Poměr%]" Display="true" SortExpression="cislo_pom" UniqueName="cislo_pom" ReadOnly="true" />
                <%--<telerik:GridBoundColumn DataField="id_pomucky" Display="false" SortExpression="id_pomucky" UniqueName="id_pomucky" />--%>
                <telerik:GridBoundColumn DataField="id_pomucky" HeaderText="[%ID%]" Display="true" SortExpression="id_pomucky" UniqueName="id_pomucky" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="pomucka" HeaderText="[%Pomůcka%]" Display="true" SortExpression="pomucka" UniqueName="pomucka" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="mnozstvi" HeaderText="[%Množství%]" Display="true" SortExpression="mnozstvi" UniqueName="mnozstvi" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="narok_podle" HeaderText="[%Nárok%]" Display="true" SortExpression="narok_podle" UniqueName="narok_podle" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="perioda" HeaderText="[%Perioda%]" Display="true" SortExpression="perioda" UniqueName="perioda" ReadOnly="true" />
                <telerik:GridTemplateColumn UniqueName="editCol" ItemStyle-HorizontalAlign="Center">
                    <EditItemTemplate>
                        <kspwc:TRadButton runat="server" ID="TRB_Save" AutoPostBack="true" CommandName="Update" ToolTip="[%Uložit%]" Icon-PrimaryIconCssClass="fi fi-disk"></kspwc:TRadButton>
                        <kspwc:TRadButton runat="server" ID="TRB_CancelEdit" CommandName="Cancel" ToolTip="[%Zrušit%]" Icon-PrimaryIconCssClass="fi fi-ban"></kspwc:TRadButton>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <kspwc:TRadButton runat="server" ID="TRB_Edit" AutoPostBack="true" CommandName="Edit" Icon-PrimaryIconCssClass="fi fi-edit-alt"></kspwc:TRadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="id_velikosti" Display="false" SortExpression="id_velikosti" UniqueName="id_velikosti" />
                <telerik:GridTemplateColumn HeaderText="[%Velikost%]" UniqueName="velikost">
                    <ItemTemplate>
                        <%--<asp:Label ID="Label_velikost" Text='<%# Eval("velikost") %>' runat="server"></asp:Label>--%>
                        <asp:Label ID="Label_Velikost" Text='<%# KSProgram.Personal.Pomucky.GetVelikost(Eval("id_velikosti")) %>' runat="server"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <kspwc:TDropDown ID="TDropDown_Velikost" runat="server" DataSourceID="ODS_VelikostiPomucky" DataValueField="Id" DataTextField="Hodnota"></kspwc:TDropDown>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="datum_potvrzeni" HeaderText="[%Potvrzeno%]" Display="true" SortExpression="datum_potvrzeni" UniqueName="datum_potvrzeni" ReadOnly="true" DataFormatString="{0:d.M.yyyy}" />
                <telerik:GridBoundColumn DataField="vydano" HeaderText="[%Vydáno%]" Display="true" SortExpression="vydano" UniqueName="vydano" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="datum_vydeje_posl" HeaderText="[%Dat. Výdeje%]" Display="true" SortExpression="datum_vydeje_posl" UniqueName="datum_vydeje_posl" ReadOnly="true" DataFormatString="{0:d}" />
                <telerik:GridBoundColumn DataField="datum_vydeje_nasl" HeaderText="[%Další výdej%]" Display="true" SortExpression="datum_vydeje_nasl" UniqueName="datum_vydeje_nasl" ReadOnly="true" DataFormatString="{0:d}" />
                <telerik:GridBoundColumn DataField="id_narok" Display="false" SortExpression="id_narok" UniqueName="id_narok" ReadOnly="true" />
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GcIc" runat="server"></kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

    <br />
    <br />
    <kspwc:TRadButton runat="server" ID="TRB_Uloz" AutoPostBack="true" Text="[%Potvrdit velikosti%]" Icon-PrimaryIconCssClass="fi fi-disk" OnClick="TRB_Uloz_Click"></kspwc:TRadButton>

    <br />
    <br />
    <br />

    <kspwc:TRadGrid ID="TRG_Vydane" runat="server" AllowPaging="true" ShowGroupPanel="false" AllowMultiRowSelection="false" OnNeedDataSource="TRG_Vydane_NeedDataSource"
        AllowSorting="true" AutoGenerateColumns="false" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true">
        <MasterTableView CommandItemDisplay="Top" Caption="[%Historie vydaných pomůcek%]" EditMode="InPlace" AutoGenerateColumns="False" ShowFooter="false" PageSize="15">
            <Columns>
                <telerik:GridBoundColumn DataField="id_pomucky" HeaderText="[%ID%]" Display="true" SortExpression="id_pomucky" UniqueName="id_pomucky" />
                <telerik:GridBoundColumn DataField="id_na_sklade" HeaderText="[%ID%]" Display="false" SortExpression="id_na_sklade" UniqueName="id_na_sklade" />
                <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Pomůcka%]" Display="true" SortExpression="nazev" UniqueName="nazev" />
                <telerik:GridBoundColumn DataField="mnozstvi" HeaderText="[%Množství%]" Display="true" SortExpression="mnozstvi" UniqueName="mnozstvi" />
                <telerik:GridBoundColumn DataField="narok_podle" HeaderText="[%Nárok%]" Display="true" SortExpression="narok_podle" UniqueName="narok_podle" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="dat_vydeje" HeaderText="[%Vydáno%]" Display="true" SortExpression="dat_vydeje" UniqueName="dat_vydeje" ReadOnly="true" DataFormatString="{0:d}" />
                <telerik:GridBoundColumn DataField="dat_vrac" HeaderText="[%Vráceno%]" Display="true" SortExpression="dat_vrac" UniqueName="dat_vrac" ReadOnly="true" DataFormatString="{0:d}" />
                <telerik:GridBoundColumn DataField="vracet" Display="true" HeaderText="[%Vracet%]" SortExpression="vracet" UniqueName="vracet" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="stav" Display="true" HeaderText="[%Stav%]" SortExpression="stav" UniqueName="stav" ReadOnly="true" />
                <telerik:GridBoundColumn DataField="id_narok" Display="false" SortExpression="id_narok" UniqueName="id_narok" ReadOnly="true" />
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GcIc3" runat="server"></kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

</asp:Content>
