/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.powerbuilder.jdbc;

import com.sybase.powerbuilder.jdbc.PbjdbcError;
import com.sybase.powerbuilder.jdbc.PbjdbcTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;

public class PbjdbcRowSet {
    ResultSet m_ResultSet;
    ResultSetMetaData m_RSMetaData;
    Calendar m_Calendar;
    PbjdbcError m_Error = null;
    Hashtable m_Hashtable;
    Blob m_blob;

    public PbjdbcRowSet(ResultSet resultSet) {
        this.m_ResultSet = resultSet;
        this.m_blob = null;
        try {
            this.m_RSMetaData = resultSet.getMetaData();
            this.m_Calendar = Calendar.getInstance();
            this.m_Hashtable = new Hashtable();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::PbjdbcRowSet SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
        }
    }

    public int CloseResultSet() {
        try {
            this.m_ResultSet.close();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::CloseResultSet SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int GetColumnCount() throws NullPointerException, SQLException {
        int n = 0;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnCount No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n = this.m_RSMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnCount SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n;
    }

    public String GetColumnName(int n) throws NullPointerException, SQLException {
        String string;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnName No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            string = this.m_RSMetaData.getColumnName(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnName SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int GetColumnType(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnType No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_RSMetaData.getColumnType(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnType SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public int GetColumnLength(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnLength(n);
    }

    public int GetColumnLength(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnLength No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_RSMetaData.getColumnDisplaySize(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnLength SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public int GetScale(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetScale No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_RSMetaData.getScale(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetScale SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public int GetPrecision(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetPrecision No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_RSMetaData.getPrecision(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetPrecision SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public int IsNullable(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::IsNullable No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_RSMetaData.isNullable(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::IsNullable SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (n2 == 1 || n2 == 2) {
            return 1;
        }
        return 0;
    }

    public String GetColumnTypeName(int n) throws NullPointerException, SQLException {
        String string;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnTypeName No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            string = this.m_RSMetaData.getColumnTypeName(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnTypeName SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int IsAutoIncrement(int n) throws NullPointerException, SQLException {
        boolean bl;
        this.m_Error = null;
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::IsAutoIncrement No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            bl = this.m_RSMetaData.isAutoIncrement(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::IsAutoIncrement SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    public int GetColumnInt(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnInt(n);
    }

    public int GetColumnInt(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnInt No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnInt No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            n2 = this.m_ResultSet.getInt(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnInt SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public long GetColumnLong(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnLong(n);
    }

    public long GetColumnLong(int n) throws NullPointerException, SQLException {
        long l;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnLong No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnLong No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            l = this.m_ResultSet.getLong(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnLong SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return l;
    }

    public short GetColumnShort(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnShort(n);
    }

    public short GetColumnShort(int n) throws NullPointerException, SQLException {
        short s;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnShort No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnShort No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            s = this.m_ResultSet.getShort(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnShort SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return s;
    }

    public float GetColumnFloat(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnFloat(n);
    }

    public float GetColumnFloat(int n) throws NullPointerException, SQLException {
        float f;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnFloat No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnFloat No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            f = this.m_ResultSet.getFloat(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnFloat SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return f;
    }

    public double GetColumnDouble(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnDouble(n);
    }

    public double GetColumnDouble(int n) throws NullPointerException, SQLException {
        double d;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnDouble No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnDouble No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            d = this.m_ResultSet.getDouble(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnDouble SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return d;
    }

    public InputStream GetBinaryStream(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetBinaryStream(n);
    }

    public InputStream GetBinaryStream(int n) throws NullPointerException, SQLException {
        InputStream inputStream;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBinaryStream No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBinaryStream No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            inputStream = this.m_ResultSet.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBinaryStream SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return inputStream;
    }

    public InputStream GetAsciiStream(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetAsciiStream(n);
    }

    public InputStream GetAsciiStream(int n) throws NullPointerException, SQLException {
        InputStream inputStream;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetAsciiStream No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetAsciiStream No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            inputStream = this.m_ResultSet.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetAsciiStream SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return inputStream;
    }

    public String GetClob(int n, int n2) throws NullPointerException, SQLException {
        this.m_Error = null;
        Object object = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetClob No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetClob No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            int n3;
            char[] cArray = new char[n2];
            Reader reader = this.m_ResultSet.getCharacterStream(n);
            object = reader != null ? ((n3 = reader.read(cArray, 0, n2)) < 0 || n3 > n2 ? new String(cArray) : (n3 == 0 ? null : new String(cArray, 0, n3))) : null;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetClob SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            PbjdbcTrace.TraceMessage(iOException.toString());
            this.m_Error = new PbjdbcError(1, iOException.toString());
        }
        return object;
    }

    public InputStream GetBlobStream(int n) throws NullPointerException, SQLException {
        InputStream inputStream;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBlobStream No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        try {
            if (this.m_blob == null) {
                this.m_blob = this.m_ResultSet.getBlob(n);
            }
            inputStream = this.m_blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBlobStream SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return inputStream;
    }

    public long GetBlobLength(int n) throws NullPointerException, SQLException {
        this.m_Error = null;
        long l = 0L;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBlobLength No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        try {
            if (this.m_blob == null) {
                this.m_blob = this.m_ResultSet.getBlob(n);
            }
            l = this.m_blob.length();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetBlobLength SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return l;
    }

    public byte GetColumnByte(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnByte No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnByte No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            by = this.m_ResultSet.getByte(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnByte SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public String GetColumnString(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnString(n);
    }

    public String GetColumnString(int n) throws NullPointerException, SQLException {
        this.m_Error = null;
        String string = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnString No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnString No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            string = this.m_ResultSet.getString(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnString SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (string == null) {
            string = new String("");
        }
        return string;
    }

    public boolean GetColumnBoolean(String string) throws NullPointerException, SQLException {
        int n;
        this.m_Error = null;
        try {
            n = this.m_ResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            if (string != null && string.trim().equals("FIXED_PREC_SCALE")) {
                return false;
            }
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return this.GetColumnBoolean(n);
    }

    public boolean GetColumnBoolean(int n) throws NullPointerException, SQLException {
        boolean bl;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnBoolean No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnBoolean No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            bl = this.m_ResultSet.getBoolean(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetColumnBoolean SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return bl;
    }

    public short GetYear1(int n) throws NullPointerException, SQLException {
        short s;
        this.m_Error = null;
        int n2 = 0;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear1 No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear1 No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n3 = this.m_RSMetaData.getColumnType(n);
                switch (n3) {
                    case 91: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        n2 = timestamp.getNanos();
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        if (this.m_Calendar.get(14) != 0 || (n2 /= 1000000) <= 0) break;
                        this.m_Calendar.set(14, n2);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear1 Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            s = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (short)0 : (short)this.m_Calendar.get(1);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear1 SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return s;
    }

    public short GetYear(int n) throws NullPointerException, SQLException {
        short s;
        this.m_Error = null;
        int n2 = 0;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n3 = this.m_RSMetaData.getColumnType(n);
                switch (n3) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        n2 = timestamp.getNanos();
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        if (this.m_Calendar.get(14) != 0 || (n2 /= 1000000) <= 0) break;
                        this.m_Calendar.set(14, n2);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            s = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (short)0 : (short)this.m_Calendar.get(1);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetYear SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return s;
    }

    public byte GetMonth(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMonth No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMonth No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n2 = this.m_RSMetaData.getColumnType(n);
                switch (n2) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMonth Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMonth SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetDay(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetDay No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetDay No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n2 = this.m_RSMetaData.getColumnType(n);
                switch (n2) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetDay Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(5);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetDay SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetHour(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        int n2 = 0;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetHour No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetHour No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n3 = this.m_RSMetaData.getColumnType(n);
                switch (n3) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        n2 = timestamp.getNanos();
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        if (this.m_Calendar.get(14) != 0 || (n2 /= 1000000) <= 0) break;
                        this.m_Calendar.set(14, n2);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetHour Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(11);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetHour SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetMinute(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMinute No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMinute No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n2 = this.m_RSMetaData.getColumnType(n);
                switch (n2) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMinute Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(12);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMinute SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetSecond(int n) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetSecond No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetSecond No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n2 = this.m_RSMetaData.getColumnType(n);
                switch (n2) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetSecond Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(13);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetSecond SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public int GetMillisecond(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMillisecond No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            throw new NullPointerException();
        }
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMillisecond No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                int n3 = this.m_RSMetaData.getColumnType(n);
                switch (n3) {
                    case 91: {
                        Date date = this.m_ResultSet.getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = this.m_ResultSet.getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.m_ResultSet.getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMillisecond Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            if (this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null")) {
                n2 = 0;
            } else {
                n2 = this.m_Calendar.get(14);
                n2 *= 1000;
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::GetMillisecond SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public boolean WasNull() throws SQLException {
        boolean bl;
        this.m_Error = null;
        try {
            bl = this.m_ResultSet.wasNull();
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return bl;
    }

    public int FetchNext() {
        this.m_Error = null;
        boolean bl = false;
        this.m_Hashtable.clear();
        if (this.m_RSMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::FetchNext No ResultSetMetaData");
            this.m_Error = new PbjdbcError(2, "No ResultSetMetaData.");
            return -1;
        }
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::FetchNext No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet.");
            return -1;
        }
        try {
            bl = this.m_ResultSet.next();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcRowSet::FetchNext SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        if (!bl) {
            return 0;
        }
        return 1;
    }

    public PbjdbcError GetLastError() {
        return this.m_Error;
    }
}

